/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.packets;

import cofh.lib.util.position.BlockPosition;
import java.util.HashSet;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkTaskPacket
extends MatterNetworkPacket {
    private long taskID;
    private byte queueID = (byte)-1;

    public MatterNetworkTaskPacket() {
    }

    public MatterNetworkTaskPacket(IMatterNetworkDispatcher sender, long taskID, byte queueID, ForgeDirection port) {
        this(sender.getPosition(), taskID, queueID, port);
    }

    public MatterNetworkTaskPacket(IMatterNetworkDispatcher sender, MatterNetworkTask task, byte queueID, ForgeDirection port) {
        this(sender.getPosition(), task.getId(), queueID, port);
    }

    public MatterNetworkTaskPacket(IMatterNetworkDispatcher sender, MatterNetworkTask task, byte queueID, ForgeDirection port, NBTTagCompound filter) {
        this(sender.getPosition(), task.getId(), queueID, port, filter);
    }

    public MatterNetworkTaskPacket(BlockPosition sender, long taskID, byte queueID, ForgeDirection port) {
        this(sender, taskID, queueID, port, null);
    }

    public MatterNetworkTaskPacket(BlockPosition sender, long taskID, byte queueID, ForgeDirection port, NBTTagCompound filter) {
        super(sender, port);
        this.taskID = taskID;
        this.queueID = queueID;
        this.filter = filter;
    }

    public MatterNetworkTaskPacket copy(IMatterNetworkConnection connection) {
        MatterNetworkTaskPacket newPacket = new MatterNetworkTaskPacket(this.senderPos, this.taskID, this.queueID, this.senderPos.orientation, this.filter);
        newPacket.path = new HashSet(this.path);
        this.addToPath(connection, ForgeDirection.UNKNOWN);
        return newPacket;
    }

    public MatterNetworkTask getTask(World world) {
        IMatterNetworkConnection sender = this.getSender(world);
        if (sender != null && sender instanceof IMatterNetworkDispatcher) {
            return ((IMatterNetworkDispatcher)sender).getTaskQueue(this.queueID).getWithID(this.taskID);
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        if (tagCompound != null) {
            this.taskID = tagCompound.func_74763_f("TaskID");
            this.queueID = tagCompound.func_74771_c("QueueID");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        if (tagCompound != null) {
            tagCompound.func_74772_a("TaskID", this.taskID);
            tagCompound.func_74774_a("QueueID", this.queueID);
        }
    }

    @Override
    public boolean isValid(World world) {
        return this.queueID >= 0 && this.getTask(world) != null && this.getTask(world).getState() != MatterNetworkTaskState.INVALID;
    }

    @Override
    public String getName() {
        return "Task Packet";
    }

    @Override
    public void tickAlive(World world, boolean isAlive) {
        super.tickAlive(world, isAlive);
        this.getTask(world).setAlive(isAlive);
    }

    @Override
    public void onAddedToQueue(World world, MatterNetworkPacketQueue packetQueue, int queueID) {
        super.onAddedToQueue(world, packetQueue, queueID);
        MatterNetworkTask task = this.getTask(world);
        if (task != null) {
            task.setState(MatterNetworkTaskState.QUEUED);
        }
    }
}

