/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cofh.lib.util.TimeTracker;
import cpw.mods.fml.common.gameevent.TickEvent;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClientDispatcher;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.tile.TileEntityMachineReplicator;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentReplicator
extends MatterNetworkComponentClientDispatcher<MatterNetworkTaskReplicatePattern, TileEntityMachineReplicator> {
    private TimeTracker patternSearchTracker = new TimeTracker();

    public MatterNetworkComponentReplicator(TileEntityMachineReplicator replicator) {
        super(replicator, TickEvent.Phase.END);
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        if (super.canPreform(packet)) {
            if (packet instanceof MatterNetworkTaskPacket) {
                if (((MatterNetworkTaskPacket)packet).getTask(((TileEntityMachineReplicator)this.rootClient).func_145831_w()) instanceof MatterNetworkTaskReplicatePattern) {
                    return ((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).remaintingCapacity() > 0;
                }
            } else {
                if (packet instanceof MatterNetworkRequestPacket) {
                    return ((MatterNetworkRequestPacket)packet).getRequestType() == 0 || ((MatterNetworkRequestPacket)packet).getRequestType() == 2;
                }
                if (packet instanceof MatterNetworkResponsePacket) {
                    return ((MatterNetworkResponsePacket)packet).getRequestType() == 1 && ((MatterNetworkResponsePacket)packet).getResponseType() == 1;
                }
            }
        }
        return false;
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        if (packet instanceof MatterNetworkTaskPacket) {
            this.executeTasks((MatterNetworkTaskPacket)packet, ((MatterNetworkTaskPacket)packet).getTask(this.getWorldObj()));
        } else if (packet instanceof MatterNetworkResponsePacket) {
            this.executeResponses((MatterNetworkResponsePacket)packet);
        } else if (packet instanceof MatterNetworkRequestPacket) {
            this.executeBasicRequestPackets((MatterNetworkRequestPacket)packet);
        }
    }

    protected void executeTasks(MatterNetworkTaskPacket packet, MatterNetworkTask task) {
        if (task instanceof MatterNetworkTaskReplicatePattern && ((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).queue((MatterNetworkTaskReplicatePattern)task)) {
            task.setState(MatterNetworkTaskState.QUEUED);
            task.setAlive(true);
            ((TileEntityMachineReplicator)this.rootClient).ForceSync();
        }
    }

    protected void executeResponses(MatterNetworkResponsePacket packet) {
        if (packet.getRequestType() == 1 && packet.getResponseType() == 1) {
            NBTTagCompound responseTag = packet.getResponse();
            MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).peek();
            if (responseTag != null && responseTag.func_74765_d("id") == task.getItemID() && responseTag.func_74765_d("Damage") == task.getItemMetadata()) {
                if (((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage() != null && ((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage().func_74765_d("id") == responseTag.func_74765_d("id") && ((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage().func_74765_d("Damage") == responseTag.func_74765_d("Damage") && MatterDatabaseHelper.GetProgressFromNBT(((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage()) > MatterDatabaseHelper.GetProgressFromNBT(responseTag)) {
                    return;
                }
                ((TileEntityMachineReplicator)this.rootClient).setInternalPatternStorage(responseTag);
                ((TileEntityMachineReplicator)this.rootClient).ForceSync();
            }
        }
    }

    @Override
    public int manageTopQueue(World world, int queueID, MatterNetworkTaskReplicatePattern task) {
        int broadcasts = 0;
        if (((TileEntityMachineReplicator)this.rootClient).getRedstoneActive() && !((TileEntityMachineReplicator)this.rootClient).canCompleteTask(task)) {
            TileEntityMachineReplicator cfr_ignored_0 = (TileEntityMachineReplicator)this.rootClient;
            if (this.patternSearchTracker.hasDelayPassed(world, 60) && task != null) {
                for (int i = 0; i < 6; ++i) {
                    MatterNetworkRequestPacket requestPacket = new MatterNetworkRequestPacket((IMatterNetworkConnection)((Object)this.rootClient), 1, ForgeDirection.getOrientation((int)i), ((TileEntityMachineReplicator)this.rootClient).getFilter(), new int[]{task.getItemID(), task.getItemMetadata()});
                    if (!MatterNetworkHelper.broadcastPacketInDirection(world, requestPacket, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)i))) continue;
                    ++broadcasts;
                }
            }
        }
        return broadcasts;
    }
}

