/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.fusionReactorController;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.lib.util.position.IRotateableTile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.text.DecimalFormat;
import java.util.EnumSet;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterConnection;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.fusionReactorController.components.ComponentComputers;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

@Optional.InterfaceList(value={@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="OpenComputers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityMachineFusionReactorController
extends MOTileEntityMachineMatter
implements IRotateableTile,
IMatterConnection,
IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public static int STRUCTURE_CHECK_DELAY = 40;
    public static final int[] positions = new int[]{0, 5, 1, 0, 2, 0, 3, 1, 4, 2, 5, 3, 5, 4, 5, 5, 5, 6, 5, 7, 4, 8, 3, 9, 2, 10, 1, 10, 0, 10, -1, 10, -2, 10, -3, 9, -4, 8, -5, 7, -5, 6, -5, 5, -5, 4, -5, 3, -4, 2, -3, 1, -2, 0, -1, 0};
    public static final int[] blocks = new int[]{255, 2, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 2};
    public static final int positionsCount = positions.length / 2;
    public static int MAX_GRAVITATIONAL_ANOMALY_DISTANCE = 3;
    public static int ENERGY_STORAGE = 100000000;
    public static int MATTER_STORAGE = 2048;
    public static int ENERGY_PER_TICK = 2048;
    public static double MATTER_DRAIN_PER_TICK = 0.0125;
    private boolean validStructure = false;
    private String monitorInfo = "INVALID STRUCTURE";
    private float energyEfficiency;
    private int energyPerTick;
    private TimeTracker structureCheckTimer = new TimeTracker();
    private BlockPosition anomalyPosition;
    private float matterPerTick;
    private float matterDrain;
    private ComponentComputers componentComputers;

    public TileEntityMachineFusionReactorController() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxTransfer(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxExtract(MATTER_STORAGE);
        this.matterStorage.setMaxReceive(MATTER_STORAGE);
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74757_a("ValidStructure", this.validStructure);
            nbt.func_74778_a("MonitorInfo", this.monitorInfo);
            nbt.func_74776_a("EnergyEfficiency", this.energyEfficiency);
            nbt.func_74776_a("MatterPerTick", this.matterPerTick);
            nbt.func_74768_a("EnergyPerTick", this.energyPerTick);
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.validStructure = nbt.func_74767_n("ValidStructure");
            this.monitorInfo = nbt.func_74779_i("MonitorInfo");
            this.energyEfficiency = nbt.func_74760_g("EnergyEfficiency");
            this.matterPerTick = nbt.func_74760_g("MatterPerTick");
            this.energyPerTick = nbt.func_74762_e("EnergyPerTick");
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.manageStructure();
            this.manageEnergyGeneration();
            this.manageEnergyExtract();
        }
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentComputers = new ComponentComputers(this);
        this.addComponent(this.componentComputers);
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.isValidStructure() && this.isGeneratingPower();
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    public Vec3 getPosition(int i, int meta) {
        if (i < positionsCount) {
            ForgeDirection back = ForgeDirection.getOrientation((int)BlockHelper.getOppositeSide((int)meta));
            Vec3 pos = Vec3.func_72443_a((double)positions[i * 2], (double)0.0, (double)positions[i * 2 + 1]);
            if (back == ForgeDirection.NORTH) {
                pos.func_72442_b((float)Math.PI);
            } else if (back == ForgeDirection.WEST) {
                pos.func_72442_b(4.712389f);
            } else if (back == ForgeDirection.EAST) {
                pos.func_72442_b(1.5707964f);
            } else if (back == ForgeDirection.UP) {
                pos.func_72440_a(1.5707964f);
            } else if (back == ForgeDirection.DOWN) {
                pos.func_72440_a(4.712389f);
            }
            return pos;
        }
        return null;
    }

    public void manageStructure() {
        if (this.structureCheckTimer.hasDelayPassed(this.field_145850_b, STRUCTURE_CHECK_DELAY)) {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int anomalyDistance = MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1;
            boolean validStructure = true;
            String info = this.monitorInfo;
            float energyEfficiency = this.energyEfficiency;
            float matterPerTick = this.matterPerTick;
            for (int i = 0; i < positionsCount; ++i) {
                Vec3 offset = this.getPosition(i, meta);
                BlockPosition position = new BlockPosition(this.field_145851_c + (int)Math.round(offset.field_72450_a), this.field_145848_d + (int)Math.round(offset.field_72448_b), this.field_145849_e + (int)Math.round(offset.field_72449_c));
                if (blocks[i] == 255) {
                    BlockPosition anomalyOffset = this.checkForGravitationalAnomaly(position, ForgeDirection.getOrientation((int)BlockHelper.getAboveSide((int)meta)));
                    if (anomalyOffset != null) {
                        anomalyDistance = (int)Math.sqrt(anomalyOffset.x * anomalyOffset.x + anomalyOffset.y * anomalyOffset.y + anomalyOffset.z * anomalyOffset.z);
                        if (anomalyDistance > MAX_GRAVITATIONAL_ANOMALY_DISTANCE) {
                            validStructure = false;
                            info = "GRAVITATIONAL\nANOMALY\nTOO\nFAR";
                            break;
                        }
                    } else {
                        validStructure = false;
                        info = "NO\nGRAVITATIONAL\nANOMALY";
                        this.anomalyPosition = null;
                        break;
                    }
                    this.anomalyPosition = new BlockPosition((int)offset.field_72450_a + anomalyOffset.x, (int)offset.field_72448_b + anomalyOffset.y, (int)offset.field_72449_c + anomalyOffset.z);
                    energyEfficiency = 1.0f - (float)anomalyDistance / (float)(MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1);
                    this.energyPerTick = (int)Math.round((double)((float)ENERGY_PER_TICK * this.getEnergyEfficiency()) * this.getGravitationalAnomalyEnergyMultiply());
                    double energyMultipy = this.getGravitationalAnomalyEnergyMultiply();
                    matterPerTick = (float)(MATTER_DRAIN_PER_TICK * energyMultipy);
                    continue;
                }
                if (position.getBlock(this.field_145850_b) == Blocks.field_150350_a) {
                    validStructure = false;
                    info = "INVALID\nSTRUCTURE";
                    break;
                }
                if (position.getBlock(this.field_145850_b) == MatterOverdriveBlocks.machine_hull) {
                    if (blocks[i] != 1) continue;
                    validStructure = false;
                    info = "NEED\nMORE\nCOILS";
                    break;
                }
                if (position.getBlock(this.field_145850_b) == MatterOverdriveBlocks.fusion_reactor_coil) {
                    if (blocks[i] != 0) continue;
                    validStructure = false;
                    info = "INVALID\nMATERIALS";
                    break;
                }
                if (position.getBlock(this.field_145850_b) == MatterOverdriveBlocks.decomposer) {
                    if (blocks[i] == 2) continue;
                    validStructure = false;
                    info = "INVALID\nMATERIALS";
                    break;
                }
                validStructure = false;
                info = "INVALID\nMATERIALS";
                break;
            }
            if (validStructure) {
                info = "POWER " + Math.round((1.0f - (float)anomalyDistance / (float)(MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1)) * 100.0f) + "%";
                info = info + "\nCHARGE " + DecimalFormat.getPercentInstance().format((double)this.getEnergyStored(ForgeDirection.UNKNOWN) / (double)this.getMaxEnergyStored(ForgeDirection.UNKNOWN));
                info = info + "\nMATTER " + DecimalFormat.getPercentInstance().format((double)this.getMatterStored() / (double)this.getMatterCapacity());
            } else {
                energyEfficiency = 0.0f;
            }
            if (this.validStructure != validStructure || !this.monitorInfo.equals(info) || this.energyEfficiency != energyEfficiency || this.matterPerTick != matterPerTick) {
                this.validStructure = validStructure;
                this.monitorInfo = info;
                this.energyEfficiency = energyEfficiency;
                this.matterPerTick = matterPerTick;
                this.ForceSync();
            }
        }
    }

    private void manageEnergyGeneration() {
        int energyPerTick;
        int energyRecived;
        if (this.isActive() && (energyRecived = this.energyStorage.receiveEnergy(energyPerTick = this.getEnergyPerTick(), false)) > 0) {
            this.matterDrain += this.getMatterDrainPerTick() * ((float)energyRecived / (float)energyPerTick);
            if (MathHelper.func_76141_d((float)this.matterDrain) >= 1) {
                this.matterStorage.extractMatter(MathHelper.func_76141_d((float)this.matterDrain), false);
                this.updateClientMatter();
                this.matterDrain -= (float)MathHelper.func_76141_d((float)this.matterDrain);
            }
        }
    }

    private void manageEnergyExtract() {
        if (this.energyStorage.getEnergyStored() > 0) {
            int startDir = random.nextInt(6);
            for (int i = 0; i < 6; ++i) {
                int energy = Math.min(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxExtract());
                ForgeDirection dir = ForgeDirection.getOrientation((int)((i + startDir) % 6));
                TileEntity entity = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (entity instanceof IEnergyConnection) {
                    ((IEnergyConnection)entity).canConnectEnergy(dir.getOpposite());
                }
                if (!(entity instanceof IEnergyReceiver)) continue;
                this.energyStorage.extractEnergy(((IEnergyReceiver)entity).receiveEnergy(dir.getOpposite(), energy, false), false);
            }
        }
    }

    @Override
    public boolean isCharging() {
        return this.inventory.func_70301_a(this.energySlotID) != null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory.func_70301_a(this.energySlotID));
    }

    @Override
    protected void manageCharging() {
        if (this.isCharging() && !this.field_145850_b.field_72995_K) {
            int maxExtracted = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            int extracted = EnergyHelper.insertEnergyIntoContainer((ItemStack)this.inventory.func_70301_a(this.energySlotID), (int)maxExtracted, (boolean)false);
            this.energyStorage.extractEnergy(extracted, false);
        }
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    public double getGravitationalAnomalyEnergyMultiply() {
        TileEntity entity;
        if (this.anomalyPosition != null && (entity = this.field_145850_b.func_147438_o(this.field_145851_c + this.anomalyPosition.x, this.field_145848_d + this.anomalyPosition.y, this.field_145849_e + this.anomalyPosition.z)) instanceof TileEntityGravitationalAnomaly) {
            return ((TileEntityGravitationalAnomaly)entity).getRealMassUnsuppressed();
        }
        return 0.0;
    }

    public float getMatterDrainPerTick() {
        return this.matterPerTick;
    }

    public boolean isGeneratingPower() {
        return this.getEnergyEfficiency() > 0.0f && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored() && (float)this.getMatterStorage().getMatterStored() > this.getMatterDrainPerTick();
    }

    public float getEnergyEfficiency() {
        return this.energyEfficiency;
    }

    private BlockPosition checkForGravitationalAnomaly(BlockPosition position, ForgeDirection up) {
        for (int i = -MAX_GRAVITATIONAL_ANOMALY_DISTANCE; i < MAX_GRAVITATIONAL_ANOMALY_DISTANCE + 1; ++i) {
            int offsetX = up.offsetX * i;
            int offsetY = up.offsetY * i;
            int offsetZ = up.offsetZ * i;
            Block block = this.field_145850_b.func_147439_a(position.x + offsetX, position.y + offsetY, position.z + offsetZ);
            if (block == null || block != MatterOverdriveBlocks.gravitational_anomaly) continue;
            return new BlockPosition(offsetX, offsetY, offsetZ);
        }
        return null;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        ForgeDirection backSide = ForgeDirection.getOrientation((int)BlockHelper.getOppositeSide((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + backSide.offsetX * 10), (double)(this.field_145848_d + backSide.offsetY * 10), (double)(this.field_145849_e + backSide.offsetZ * 10));
    }

    public boolean isValidStructure() {
        return this.validStructure;
    }

    public String getMonitorInfo() {
        return this.monitorInfo;
    }

    public boolean canRotate() {
        return true;
    }

    public boolean canRotate(ForgeDirection axis) {
        return true;
    }

    public void rotate(ForgeDirection axis) {
        System.out.println("Rotate");
    }

    public void rotateDirectlyTo(int facing) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, facing, 3);
    }

    public ForgeDirection getDirectionFacing() {
        return ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public boolean canConnectFrom(ForgeDirection dir) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return meta != dir.ordinal();
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage || type == UpgradeTypes.Range || type == UpgradeTypes.Speed;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.componentComputers.getType();
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.componentComputers.getMethodNames();
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return this.componentComputers.callMethod(computer, context, method, arguments);
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        this.componentComputers.attach(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        this.componentComputers.detach(computer);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this.componentComputers.equals(other);
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return this.componentComputers.getComponentName();
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return this.componentComputers.methods();
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        return this.componentComputers.invoke(method, context, args);
    }
}

