/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.api.IUpgradeable;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.TileEntityInventory;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.fx.VentParticle;
import matteroverdrive.items.SecurityProtocol;
import matteroverdrive.machines.IMachineComponent;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.UpgradeHandlerMinimum;
import matteroverdrive.machines.components.ComponentConfigs;
import matteroverdrive.machines.configs.ConfigPropertyStringList;
import matteroverdrive.tile.IMOTileEntity;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public abstract class MOTileEntityMachine
extends MOTileEntity
implements IMOTileEntity,
ISidedInventory,
IUpgradeable {
    protected static Random random = new Random();
    protected static UpgradeHandlerMinimum basicUpgradeHandler = new UpgradeHandlerMinimum(0.05).addUpgradeMinimum(UpgradeTypes.Speed, 0.1);
    private boolean lastActive;
    private boolean activeState;
    @SideOnly(value=Side.CLIENT)
    protected MachineSound sound;
    protected ResourceLocation soundRes;
    protected boolean redstoneState;
    protected boolean redstoneStateDirty = true;
    protected boolean forceClientUpdate;
    protected UUID owner;
    protected Inventory inventory;
    private int upgradeSlotCount;
    private int[] upgrade_slots;
    protected List<IMachineComponent> components = new ArrayList<IMachineComponent>();
    protected boolean playerSlotsHotbar;
    protected boolean playerSlotsMain;
    protected ComponentConfigs configs;

    public MOTileEntityMachine(int upgradeCount) {
        this.soundRes = MOTileEntityMachine.getSoundFor(this.getSound());
        this.upgradeSlotCount = upgradeCount;
        this.upgrade_slots = new int[upgradeCount];
        this.inventory = new TileEntityInventory(this, "");
        this.registerComponents();
        this.RegisterSlots(this.inventory);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.manageSound();
            if (this.forceClientUpdate) {
                this.updateBlock();
                this.forceClientUpdate = false;
            }
            return;
        }
        this.activeState = this.getServerActive();
        if (this.lastActive != this.activeState) {
            this.ForceSync();
            this.onActiveChange();
            this.lastActive = this.activeState;
        }
        this.manageRedstoneState();
        this.manageClientSync();
        if (this.lastActive != this.isActive()) {
            this.onActiveChange();
            this.lastActive = this.isActive();
        }
        for (IMachineComponent component : this.components) {
            try {
                component.update(this);
            }
            catch (Exception e) {
                MOLog.log(Level.FATAL, e, "There was a problem while ticking %s component %s", this, component);
            }
        }
    }

    protected void RegisterSlots(Inventory inventory) {
        for (int i = 0; i < this.upgrade_slots.length; ++i) {
            this.upgrade_slots[i] = inventory.AddSlot(new UpgradeSlot(false, this));
        }
        for (IMachineComponent component : this.components) {
            component.registerSlots(inventory);
        }
    }

    protected void registerComponents() {
        this.configs = new ComponentConfigs(this);
        this.configs.addProperty(new ConfigPropertyStringList("redstoneMode", "gui.config.redstone", new String[]{MOStringHelper.translateToLocal("gui.redstone_mode.high"), MOStringHelper.translateToLocal("gui.redstone_mode.low"), MOStringHelper.translateToLocal("gui.redstone_mode.disabled")}, 1));
        this.addComponent(this.configs);
    }

    private static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation("mo:" + sound);
    }

    public abstract String getSound();

    public abstract boolean hasSound();

    public abstract boolean getServerActive();

    public abstract float soundVolume();

    public void onContainerOpen(Side side) {
    }

    public boolean getRedstoneActive() {
        if (this.getRedstoneMode() == 0) {
            return this.redstoneState;
        }
        if (this.getRedstoneMode() == 1) {
            return !this.redstoneState;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void manageSound() {
        if (this.hasSound() && this.soundVolume() > 0.0f) {
            if (this.isActive() && !this.func_145837_r()) {
                if (this.sound == null) {
                    float soundMultiply = 1.0f;
                    if (this.func_145838_q() instanceof MOBlockMachine) {
                        soundMultiply = ((MOBlockMachine)this.func_145838_q()).volume;
                    }
                    if (soundMultiply > 0.0f) {
                        this.sound = new MachineSound(this.soundRes, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.soundVolume() * soundMultiply, 1.0f);
                        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                    }
                } else if (FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.sound)) {
                    this.sound.setVolume(this.soundVolume());
                } else {
                    this.sound = null;
                }
            } else if (this.sound != null) {
                this.stopSound();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void stopSound() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopSound();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.redstoneState = nbt.func_74767_n("redstoneState");
            this.forceClientUpdate = nbt.func_74767_n("forceClientUpdate");
            this.activeState = nbt.func_74767_n("activeState");
            if (nbt.func_150297_b("Owner", 8) && !nbt.func_74779_i("Owner").isEmpty()) {
                try {
                    this.owner = UUID.fromString(nbt.func_74779_i("Owner"));
                }
                catch (Exception e) {
                    FMLLog.log((Level)Level.ERROR, (String)("Invalid Owner ID: " + nbt.func_74779_i("Owner")), (Object[])new Object[0]);
                }
            }
        }
        if (categories.contains((Object)MachineNBTCategory.INVENTORY)) {
            this.inventory.readFromNBT(nbt);
        }
        for (IMachineComponent component : this.components) {
            component.readFromNBT(nbt, categories);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74757_a("forceClientUpdate", this.forceClientUpdate);
            nbt.func_74757_a("redstoneState", this.redstoneState);
            nbt.func_74757_a("activeState", this.activeState);
            if (this.owner != null) {
                nbt.func_74778_a("Owner", this.owner.toString());
            } else if (nbt.func_150297_b("Owner", 6)) {
                nbt.func_82580_o("Owner");
            }
        }
        this.forceClientUpdate = false;
        if (categories.contains((Object)MachineNBTCategory.INVENTORY)) {
            this.inventory.writeToNBT(nbt);
        }
        for (IMachineComponent component : this.components) {
            component.writeToNBT(nbt, categories);
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound machineTag = new NBTTagCompound();
        NBTTagList itemTagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.inventory.getSlot(i).keepOnDismatle() || this.inventory.func_70301_a(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(itemTag);
            itemTagList.func_74742_a((NBTBase)itemTag);
        }
        machineTag.func_74782_a("Items", (NBTBase)itemTagList);
        this.writeCustomNBT(machineTag, EnumSet.of(MachineNBTCategory.CONFIGS, MachineNBTCategory.DATA));
        if (this.hasOwner()) {
            machineTag.func_74778_a("Owner", this.owner.toString());
        }
        itemStack.func_77978_p().func_74782_a("Machine", (NBTBase)machineTag);
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound machineTag = itemStack.func_77978_p().func_74775_l("Machine");
            NBTTagList itemTagList = machineTag.func_150295_c("Items", 10);
            for (int i = 0; i < itemTagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemTagList.func_150305_b(i);
                byte b0 = itemTag.func_74771_c("Slot");
                this.inventory.func_70299_a(b0, ItemStack.func_77949_a((NBTTagCompound)itemTag));
            }
            this.readCustomNBT(machineTag, EnumSet.of(MachineNBTCategory.CONFIGS, MachineNBTCategory.DATA));
            if (machineTag.func_150297_b("Owner", 8)) {
                try {
                    this.owner = UUID.fromString(machineTag.func_74779_i("Owner"));
                }
                catch (Exception e) {
                    FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)("Invalid Owner ID: " + machineTag.func_74779_i("Owner")), (Object[])new Object[0]);
                }
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound syncData = pkt.func_148857_g();
        if (syncData != null) {
            this.readCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        }
    }

    protected void manageRedstoneState() {
        if (this.redstoneStateDirty) {
            boolean flag = this.redstoneState;
            this.redstoneState = this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
            this.redstoneStateDirty = false;
            if (flag != this.redstoneState) {
                this.forceClientUpdate = true;
            }
        }
    }

    protected void manageClientSync() {
        if (this.forceClientUpdate) {
            this.updateBlock();
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.manageSound();
        }
    }

    protected abstract void onActiveChange();

    @Override
    public void onNeighborBlockChange() {
        this.redstoneStateDirty = true;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return this.getInventory() != null && this.getInventory().func_94041_b(slot, item);
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public int func_70302_i_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70301_a(slot);
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70298_a(slot, size);
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70304_b(slot);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(slot, itemStack);
        }
    }

    public String func_145825_b() {
        if (this.getInventory() != null) {
            return this.getInventory().func_145825_b();
        }
        return "";
    }

    public boolean func_145818_k_() {
        return this.getInventory() != null && this.getInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.hasOwner()) {
            if (player.func_146103_bH().getId().equals(this.owner) || player.field_71075_bZ.field_75098_d) {
                return true;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof SecurityProtocol) || !itemStack.func_77942_o() || itemStack.func_77960_j() != 2 || !UUID.fromString(itemStack.func_77978_p().func_74779_i("Owner")).equals(this.owner)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void func_70295_k_() {
        System.out.println("Inventory Open");
    }

    public void func_70305_f() {
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public Inventory getInventoryContainer() {
        return this.inventory;
    }

    public void ForceSync() {
        this.forceClientUpdate = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendConfigsToServer(boolean forceUpdate) {
        this.sendNBTToServer(EnumSet.of(MachineNBTCategory.CONFIGS), forceUpdate);
    }

    public double getUpgradeMultiply(UpgradeTypes type) {
        double multiply = 1.0;
        if (this.isAffectedByUpgrade(type)) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                Map<UpgradeTypes, Double> upgrades;
                ItemStack upgradeItem;
                if (!(this.inventory.getSlot(i) instanceof UpgradeSlot) || (upgradeItem = this.inventory.func_70301_a(i)) == null || !MatterHelper.isUpgrade(upgradeItem) || !(upgrades = ((IUpgrade)upgradeItem.func_77973_b()).getUpgrades(upgradeItem)).containsKey((Object)type)) continue;
                multiply *= upgrades.get((Object)type).doubleValue();
            }
            if (this.getUpgradeHandler() != null) {
                multiply = this.getUpgradeHandler().affectUpgrade(type, multiply);
            }
        }
        return multiply;
    }

    @SideOnly(value=Side.CLIENT)
    protected void SpawnVentParticles(float speed, ForgeDirection side, int count) {
        for (int i = 0; i < count; ++i) {
            Matrix4f rotation = new Matrix4f();
            Vector3f offset = new Vector3f();
            if (side == ForgeDirection.UP) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
                offset = new Vector3f(0.5f, 0.7f, 0.5f);
            } else if (side == ForgeDirection.WEST) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
                offset = new Vector3f(-0.2f, 0.5f, 0.5f);
            } else if (side == ForgeDirection.EAST) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, -1.0f));
                offset = new Vector3f(1.2f, 0.5f, 0.5f);
            } else if (side == ForgeDirection.SOUTH) {
                rotation.rotate(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
                offset = new Vector3f(0.5f, 0.5f, 1.2f);
            } else if (side == ForgeDirection.NORTH) {
                rotation.rotate(1.5707964f, new Vector3f(-1.0f, 0.0f, 0.0f));
                offset = new Vector3f(0.5f, 0.5f, -0.2f);
            }
            Vector3f circle = MOMathHelper.randomCirclePoint(random.nextFloat(), random);
            circle.scale(0.4f);
            Vector4f circleTransformed = new Vector4f(circle.x, circle.y, circle.z, 1.0f);
            Matrix4f.transform((Matrix4f)rotation, (Vector4f)circleTransformed, (Vector4f)circleTransformed);
            float scale = 3.0f;
            VentParticle ventParticle = new VentParticle(this.field_145850_b, (float)this.field_145851_c + offset.x + circleTransformed.x, (float)this.field_145848_d + offset.y + circleTransformed.y, (float)this.field_145849_e + offset.z + circleTransformed.z, (float)side.offsetX * speed, (float)side.offsetY * speed, (float)side.offsetZ * speed, scale);
            ventParticle.func_82338_g(0.05f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)ventParticle);
        }
    }

    public <T extends MOBlock> T getBlockType(Class<T> type) {
        if (this.field_145854_h == null) {
            this.field_145854_h = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (type.isInstance(this.field_145854_h)) {
            return (T)((Object)((MOBlock)((Object)type.cast(this.field_145854_h))));
        }
        return null;
    }

    public int getRedstoneMode() {
        return this.getConfigs().getInteger("redstoneMode", 1);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean claim(ItemStack security_protocol) {
        try {
            if (this.owner == null && security_protocol.func_77942_o() && security_protocol.func_77978_p().func_150297_b("Owner", 8)) {
                this.owner = UUID.fromString(security_protocol.func_77978_p().func_74779_i("Owner"));
                this.ForceSync();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean unclaim(ItemStack security_protocol) {
        try {
            if (this.owner != null && security_protocol.func_77942_o() && security_protocol.func_77978_p().func_150297_b("Owner", 8) && this.owner.equals(UUID.fromString(security_protocol.func_77978_p().func_74779_i("Owner")))) {
                this.owner = null;
                this.ForceSync();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void addComponent(IMachineComponent component) {
        this.components.add(component);
    }

    public boolean removeComponent(IMachineComponent component) {
        return this.components.remove(component);
    }

    public IMachineComponent removeComponent(int index) {
        return this.components.remove(index);
    }

    public IMachineComponent getComponent(int index) {
        return this.components.get(index);
    }

    public <T extends IMachineComponent> T getComponent(Class<T> componentClasss) {
        for (IMachineComponent component : this.components) {
            if (!componentClasss.isInstance(component)) continue;
            return (T)((IMachineComponent)componentClasss.cast(component));
        }
        return null;
    }

    public boolean hasPlayerSlotsHotbar() {
        return this.playerSlotsHotbar;
    }

    public boolean hasPlayerSlotsMain() {
        return this.playerSlotsMain;
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean isActive() {
        return this.activeState;
    }

    public void setActive(boolean active) {
        this.activeState = active;
    }

    public ComponentConfigs getConfigs() {
        return this.configs;
    }

    @Override
    public IUpgradeHandler getUpgradeHandler() {
        return basicUpgradeHandler;
    }
}

