/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.VersionCheckerHandler;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerEventHandler {
    private VersionCheckerHandler versionCheckerHandler;
    public List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();

    public PlayerEventHandler(ConfigurationHandler configurationHandler) {
        this.versionCheckerHandler = new VersionCheckerHandler();
        configurationHandler.subscribe(this.versionCheckerHandler);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            if (MatterOverdrive.matterRegistry.hasComplitedRegistration) {
                if (!MinecraftServer.func_71276_C().func_71264_H()) {
                    MatterOverdrive.packetPipeline.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries()), (EntityPlayerMP)event.player);
                }
            } else {
                this.players.add((EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AndroidPlayer player;
        if (event.side == Side.CLIENT) {
            this.versionCheckerHandler.onPlayerTick(event);
        }
        if ((player = AndroidPlayer.get(event.player)) != null) {
            if (event.side == Side.CLIENT) {
                this.onAndroidTickClient(player, event);
            } else {
                this.onAndroidServerTick(player, event);
            }
        }
        if (event.player.field_70170_p.field_72995_K && event.player.func_71011_bu() != null && event.player.func_71011_bu().func_77973_b() instanceof IWeapon) {
            ItemStack itemstack = event.player.field_71071_by.func_70448_g();
            if (itemstack != null && Minecraft.func_71410_x().field_71462_r == null) {
                if (event.player.func_71011_bu().func_77969_a(itemstack)) {
                    event.player.func_71008_a(itemstack, event.player.func_71052_bv());
                } else {
                    System.out.println(String.format("%s not equal to %s", itemstack, event.player.func_71011_bu()));
                }
            } else {
                event.player.func_71041_bz();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAndroidTickClient(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.func_71410_x().field_71439_g) {
            androidPlayer.onPlayerTick(event);
        }
    }

    private void onAndroidServerTick(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        androidPlayer.onPlayerTick(event);
    }

    @SubscribeEvent
    public void onPlayerLoadFromFile(PlayerEvent.LoadFromFile event) {
        AndroidPlayer player = AndroidPlayer.get(event.entityPlayer);
        if (player != null) {
            player.onPlayerLoad(event);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        AndroidPlayer androidPlayer;
        if (event.target instanceof EntityPlayer && (androidPlayer = AndroidPlayer.get((EntityPlayer)event.target)) != null && androidPlayer.isAndroid()) {
            androidPlayer.sync(event.entityPlayer, -1, false);
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (MatterOverdrive.matterRegistry.hasComplitedRegistration) {
            for (int i = 0; i < MatterOverdrive.playerEventHandler.players.size(); ++i) {
                MatterOverdrive.packetPipeline.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries()), MatterOverdrive.playerEventHandler.players.get(i));
            }
            MatterOverdrive.playerEventHandler.players.clear();
        }
    }
}

