/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class KeyHandler {
    public static final int MATTER_SCANNER_KEY = 0;
    public static final int ABILITY_USE_KEY = 1;
    public static final int ABILITY_SWITCH_KEY = 2;
    private static final String[] keyDesc = new String[]{"Open Matter Scanner GUI", "Android Ability key", "Android Switch Ability key"};
    private static final int[] keyValues = new int[]{46, 45, 15};
    private final KeyBinding[] keys = new KeyBinding[keyValues.length];

    public KeyHandler() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new KeyBinding(keyDesc[i], keyValues[i], "Matter Overdrive");
            ClientRegistry.registerKeyBinding((KeyBinding)this.keys[i]);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!FMLClientHandler.instance().isGUIOpen(GuiChat.class)) {
            int key = Keyboard.getEventKey();
            boolean isDown = Keyboard.getEventKeyState();
            if (isDown && this.keys[0].func_151463_i() == key) {
                MatterScanner.DisplayGuiScreen();
            }
            this.manageBiostats(key, isDown);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_147113_T() || Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        if (androidPlayer.isAndroid() && ClientProxy.keyHandler.getBinding(1).func_151468_f()) {
            for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                int level = androidPlayer.getUnlockedLevel(stat);
                if (level <= 0 || !stat.isEnabled(androidPlayer, level)) continue;
                stat.onActionKeyPress(androidPlayer, androidPlayer.getUnlockedLevel(stat), ClientProxy.keyHandler.getBinding(1));
            }
        }
    }

    public void manageBiostats(int keyCode, boolean state) {
        AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        if (androidPlayer.isAndroid()) {
            for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                int level = androidPlayer.getUnlockedLevel(stat);
                if (level <= 0 || !stat.isEnabled(androidPlayer, level)) continue;
                stat.onKeyPress(androidPlayer, androidPlayer.getUnlockedLevel(stat), keyCode, state);
            }
        }
    }

    public KeyBinding getBinding(int id) {
        return this.keys[id];
    }
}

