/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.IGuideElement;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.util.MOLog;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GuideElementPage
extends GuideElementAbstract {
    List<IGuideElement> elements = new ArrayList<IGuideElement>();

    @Override
    public void loadElement(MOGuideEntry entry, Element element, Map<String, String> styleSheetMap, int width, int height) {
        super.loadElement(entry, element, styleSheetMap, width, height);
        NodeList children = element.getChildNodes();
        for (int c = 0; c < children.getLength(); ++c) {
            Element child;
            Class<? extends IGuideElement> guideElementClass;
            if (!(children.item(c) instanceof Element) || (guideElementClass = MatterOverdriveGuide.getElementHandler((child = (Element)children.item(c)).getTagName())) == null) continue;
            try {
                IGuideElement e = guideElementClass.newInstance();
                if (e == null) continue;
                e.setGUI(this.gui);
                e.loadElement(entry, child, styleSheetMap, width - this.marginLeft - this.marginRight, height - this.marginBottom - this.marginTop);
                this.elements.add(e);
                continue;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "Could not create Guide Element of class %s", guideElementClass);
            }
        }
    }

    @Override
    protected void loadContent(MOGuideEntry entry, Element element, int width, int height) {
    }

    @Override
    public void drawElement(int width, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.marginLeft, (double)this.marginTop, (double)0.0);
        int x = 0;
        int y = 0;
        int floatRightX = width;
        int maxHeight = 0;
        for (IGuideElement element : this.elements) {
            GL11.glPushMatrix();
            if (element.getFloating() == 2) {
                GL11.glTranslated((double)(floatRightX - element.getWidth() - this.marginLeft), (double)0.0, (double)0.0);
            }
            GL11.glTranslated((double)x, (double)y, (double)0.0);
            element.drawElement(width - this.marginLeft - this.marginRight, mouseX - x - this.marginLeft, mouseY - y - this.marginTop);
            if (element.getFloating() == 1) {
                if (x + element.getWidth() > width) {
                    y += maxHeight;
                    x = 0;
                    floatRightX = width;
                    maxHeight = 0;
                } else {
                    maxHeight = Math.max(element.getHeight(), maxHeight);
                    x += element.getWidth();
                }
            } else if (element.getFloating() == 2) {
                if (floatRightX - element.getWidth() < 0) {
                    maxHeight = Math.max(maxHeight, element.getHeight());
                    floatRightX = width;
                    y += maxHeight;
                    maxHeight = 0;
                } else {
                    floatRightX -= element.getWidth();
                }
            } else {
                maxHeight = Math.max(maxHeight, element.getHeight());
                y += maxHeight;
                maxHeight = 0;
                x = 0;
                floatRightX = width;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

