/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.util.helpers.MathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGuideEntry;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveQuide;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PageInfo
extends ElementBaseGroup {
    public static final ScaleTexture GUIDES_BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/guides_bg.png"), 166, 142).setOffsets(80, 80, 72, 69);
    public static final int MAX_GUIDES_PER_ROW = 3;
    public static final String SCROLL_RIGHT_ELEMENT_NAME = "scroll_right";
    public static final String SCROLL_LEFT_ELEMENT_NAME = "scroll_left";
    public static final String RETURN_ELEMENT_NAME = "return";
    public static int guideID = -1;
    public static int tabID;
    public static int scroll;
    List<ElementBase> guideEntries;
    List<String> description;
    ElementButton bt_scroll_right;
    ElementButton bt_scroll_left;
    ElementButton bt_return;

    public PageInfo(MOGuiBase gui, int posX, int posY, int width, int height, String name) {
        super(gui, posX, posY, width, height);
        this.setName(name);
        this.guideEntries = new ArrayList<ElementBase>(MatterOverdriveQuide.getQuides().size());
        this.description = new ArrayList<String>();
        for (int i = 0; i < MatterOverdriveQuide.getQuides().size(); ++i) {
            ElementGuideEntry entry = new ElementGuideEntry(gui, 0, 0, MatterOverdriveQuide.getQuides().get(i), i);
            entry.setName("GUIDE_ENTRY");
            this.guideEntries.add(entry);
        }
        this.bt_scroll_right = new MOElementButton(gui, this, this.sizeX - 30, this.sizeY - 30, SCROLL_RIGHT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_right.setTexture("mo:textures/gui/elements/scroll_right.png", 20, 10);
        this.bt_scroll_left = new MOElementButton(gui, this, 50, this.sizeY - 30, SCROLL_LEFT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_left.setTexture("mo:textures/gui/elements/scroll_left.png", 20, 10);
        this.bt_return = new MOElementButton(gui, this, 150, this.sizeY - 30, RETURN_ELEMENT_NAME, 0, 0, 11, 0, 11, 11, "");
        this.bt_return.setTexture("mo:textures/gui/elements/return_arrow.png", 22, 11);
    }

    @Override
    public void init() {
        super.init();
        this.elements.add(this.bt_scroll_left);
        this.elements.add(this.bt_scroll_right);
        this.elements.add(this.bt_return);
        this.loadQuideInfo(guideID);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GUIDES_BG.Render(41, 26, 244, 198);
        super.drawBackground(mouseX, mouseY, gameTicks);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (guideID >= 0) {
            boolean lastUnicodeFlag = Minecraft.func_71410_x().field_71466_p.func_82883_a();
            Minecraft.func_71410_x().field_71466_p.func_78264_a(true);
            if (tabID == 0) {
                this.DrawDescription();
            }
            Minecraft.func_71410_x().field_71466_p.func_78264_a(lastUnicodeFlag);
        } else {
            for (int i = 0; i < this.guideEntries.size(); ++i) {
                int x = 48 + i % 3 * 24;
                int y = 34 + 24 * (i / 3);
                this.guideEntries.get(i).setPosition(x, y);
            }
        }
        super.drawForeground(mouseX, mouseY);
    }

    private void DrawDescription() {
        if (scroll < this.description.size() && scroll >= 0) {
            Minecraft.func_71410_x().field_71466_p.func_78264_a(true);
            Minecraft.func_71410_x().field_71466_p.func_78279_b(this.description.get(scroll), 56, 44, 210, Reference.COLOR_MATTER.getColor());
        }
        this.handleScrollButtons();
    }

    private void handleScrollButtons() {
        this.bt_scroll_left.setVisible(true);
        this.bt_scroll_right.setVisible(true);
        if (scroll >= this.description.size() - 1) {
            this.bt_scroll_right.setVisible(false);
        }
        if (scroll <= 0) {
            this.bt_scroll_left.setVisible(false);
        }
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        if (element.equals(this.bt_scroll_left)) {
            --scroll;
        } else if (element.equals(this.bt_scroll_right)) {
            ++scroll;
        } else if (element.equals(this.bt_return)) {
            this.OpenQuide(-1);
        }
        scroll = MathHelper.clampI((int)scroll, (int)0, (int)(this.description.size() - 1));
    }

    public void OpenQuide(int id) {
        guideID = id;
        this.loadQuideInfo(id);
        scroll = 0;
        tabID = 0;
    }

    private void loadQuideInfo(int guideID) {
        if (guideID >= 0 && guideID < MatterOverdriveQuide.getQuides().size()) {
            MOGuideEntry entry = MatterOverdriveQuide.getQuides().get(guideID);
            ResourceLocation descriptionLocation = entry.description;
            try {
                String line;
                InputStream descriptionStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(descriptionLocation).func_110527_b();
                LineNumberReader descriptionReader = new LineNumberReader(new InputStreamReader(descriptionStream));
                this.description.clear();
                while ((line = descriptionReader.readLine()) != null) {
                    this.description.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<ElementBase> getElements() {
        if (guideID < 0) {
            return this.guideEntries;
        }
        return this.elements;
    }
}

