/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.element.ElementBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.Bounds;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGuideCategory;
import matteroverdrive.gui.element.ElementGuideEntry;
import matteroverdrive.gui.element.ElementStatesHoloIcons;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.gui.events.ITextHandler;
import matteroverdrive.gui.pages.PageGuideDescription;
import matteroverdrive.guide.GuideCategory;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PageGuideEntries
extends ElementBaseGroup
implements ITextHandler {
    private Map<String, Bounds> groups;
    private List<ElementGuideEntry> guideEntries;
    private ElementStatesHoloIcons orderButtonElement;
    private MOElementTextField searchField;
    private PageGuideDescription pageGuideDescription;
    private ItemStack dataPadStack;
    private static int scrollX;
    private static int scrollY;
    private static String searchFilter;
    private boolean mouseIsDown;
    private int lastMouseX;
    private int lastMouseY;
    private int innerHeight;
    private int innerWidth;
    ScaleTexture groupBackground = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/guide_group.png"), 16, 16).setOffsets(5, 5, 5, 5);
    private ResourceLocation background = new ResourceLocation("mo:textures/gui/elements/guide_cuircit_background.png");
    private List<ElementGuideCategory> categories;

    public PageGuideEntries(MOGuiBase gui, int posX, int posY, int width, int height, String name, PageGuideDescription pageGuideDescription) {
        super(gui, posX, posY, width, height);
        this.setName(name);
        this.guideEntries = new ArrayList<ElementGuideEntry>(MatterOverdriveGuide.getGuides().size());
        this.groups = new HashMap<String, Bounds>();
        for (MOGuideEntry guideEntry : MatterOverdriveGuide.getGuides()) {
            ElementGuideEntry entry = new ElementGuideEntry(gui, this, guideEntry.getGuiPosX(), 32 + guideEntry.getGuiPosY(), guideEntry);
            entry.setName("GUIDE_ENTRY");
            this.guideEntries.add(entry);
        }
        this.orderButtonElement = new ElementStatesHoloIcons(gui, this, this.sizeX - 38, 2, 16, 16, "orderType", new HoloIcon[]{ClientProxy.holoIcons.getIcon("list"), ClientProxy.holoIcons.getIcon("grid"), ClientProxy.holoIcons.getIcon("sort_random")});
        this.orderButtonElement.setNormalTexture(null);
        this.orderButtonElement.setOverTexture(null);
        this.orderButtonElement.setDownTexture(null);
        this.orderButtonElement.setColor(Reference.COLOR_MATTER);
        this.searchField = new MOElementTextField(gui, this, 28, 4, 128, 10);
        this.searchField.setBackground(null);
        this.searchField.setHoloIcon(ClientProxy.holoIcons.getIcon("page_icon_search"));
        this.searchField.setColor(Reference.COLOR_MATTER);
        this.innerHeight = this.sizeY;
        this.innerWidth = this.sizeX;
        this.pageGuideDescription = pageGuideDescription;
        this.categories = new ArrayList<ElementGuideCategory>();
        for (GuideCategory category : MatterOverdriveGuide.getCategories().values()) {
            ElementGuideCategory guideCategory = new ElementGuideCategory(gui, this, 0, 0, category.getDisplayName(), 22, 22, category);
            guideCategory.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
            this.categories.add(guideCategory);
        }
    }

    @Override
    public void init() {
        super.init();
        this.elements.add(this.orderButtonElement);
        this.elements.add(this.searchField);
        this.searchField.setText(searchFilter);
        this.orderButtonElement.setSelectedState(MatterOverdriveItems.dataPad.getOrdering(this.dataPadStack));
        for (ElementGuideEntry entry : this.guideEntries) {
            this.elements.add(entry);
        }
    }

    @Override
    public void updateInfo() {
        super.updateInfo();
        this.groups.clear();
        int groupPadding = 6;
        int topOffset = 22;
        int bottomOffset = 16;
        int leftOffset = 8;
        int rightOffset = 8;
        int x = leftOffset + scrollX;
        int y = topOffset + scrollY;
        int heightCount = 0;
        int widthCount = 0;
        for (ElementGuideEntry entry : this.guideEntries) {
            if (this.searchFilterMatch(entry.getEntry(), searchFilter) && this.getActiveCategory().getEntries().contains(entry.getEntry())) {
                entry.setVisible(true);
            } else {
                entry.setVisible(false);
            }
            if (this.orderButtonElement.getSelectedState() == 0) {
                if (!entry.isVisible()) continue;
                entry.setPosition(x + 16, y);
                entry.setShowLabel(true);
                y += entry.getHeight() + 4;
                heightCount += entry.getHeight() + 4;
                continue;
            }
            if (this.orderButtonElement.getSelectedState() == 1) {
                if (!entry.isVisible()) continue;
                entry.setPosition(x, y);
                entry.setShowLabel(false);
                if ((x += entry.getWidth() + 4) <= this.sizeX - entry.getHeight() - 4) continue;
                x = 8;
                y += entry.getHeight() + 4;
                heightCount += entry.getHeight() + 4;
                continue;
            }
            if (!entry.isVisible()) continue;
            entry.setPosition(x + entry.getEntry().getGuiPosX(), y + entry.getEntry().getGuiPosY());
            entry.setShowLabel(false);
            widthCount = Math.max(widthCount, entry.getEntry().getGuiPosX() + entry.getWidth() + groupPadding + 4);
            heightCount = Math.max(heightCount, entry.getEntry().getGuiPosY() + entry.getHeight() + groupPadding + 4);
            if (entry.getEntry().getGroup() == null) continue;
            if (!this.groups.containsKey(entry.getEntry().getGroup())) {
                Bounds bounds = new Bounds(entry.getPosX() - groupPadding, entry.getPosY() - groupPadding, entry.getPosX() + entry.getWidth() + groupPadding, entry.getPosY() + entry.getHeight() + groupPadding);
                this.groups.put(entry.getEntry().getGroup(), bounds);
                continue;
            }
            this.groups.get(entry.getEntry().getGroup()).extend(entry.getPosX() - groupPadding, entry.getPosY() - groupPadding, entry.getPosX() + entry.getWidth() + groupPadding, entry.getPosY() + entry.getHeight() + groupPadding);
        }
        this.innerWidth = Math.max(widthCount + leftOffset, this.sizeX);
        this.innerHeight = Math.max(heightCount + topOffset, this.sizeY);
    }

    private boolean searchFilterMatch(MOGuideEntry entry, String searchFilter) {
        return entry.getDisplayName().toLowerCase().contains(searchFilter.toLowerCase());
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        RenderUtils.beginStencil();
        RenderUtils.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.1);
        this.gui.bindTexture(this.background);
        RenderUtils.drawPlane(this.sizeX / 2 - 512 + scrollX / 2, this.sizeY / 2 - 512 + scrollY / 2, 0.0, 1024.0, 1024.0);
        GL11.glEnable((int)3008);
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endStencil();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginStencil();
        RenderUtils.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        if (this.orderButtonElement.getSelectedState() > 1) {
            for (Map.Entry<String, Bounds> group : this.groups.entrySet()) {
                this.getFontRenderer().func_78264_a(true);
                Bounds b = group.getValue();
                RenderUtils.applyColor(Reference.COLOR_MATTER);
                this.groupBackground.Render(14 + b.getMinX(), 14 + b.getMinY(), b.getWidth(), b.getHeight());
                String groupName = MOStringHelper.translateToLocal(String.format("guide.group.%s.name", group.getKey()));
                int groupNameWidth = this.getFontRenderer().func_78256_a(groupName);
                this.getFontRenderer().func_78276_b(groupName, 14 + scrollX + b.getMinX() + b.getWidth() / 2 - groupNameWidth / 2, 10 + b.getMinY(), Reference.COLOR_MATTER.getColor());
                this.getFontRenderer().func_78264_a(false);
            }
        }
        super.drawForeground(mouseX, mouseY);
        RenderUtils.endStencil();
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        int mouseXDelta = mouseX - this.lastMouseX;
        int mouseYDelta = mouseY - this.lastMouseY;
        if (this.mouseIsDown && mouseX > 0 && mouseX < this.sizeX && mouseY > 0 && mouseY < this.sizeY) {
            scrollX += mouseXDelta;
            scrollY += mouseYDelta;
        }
        scrollX = Math.min(scrollX, 0);
        scrollX = Math.max(scrollX, this.sizeX - this.innerWidth);
        scrollY = Math.min(scrollY, 0);
        scrollY = Math.max(scrollY, this.sizeY - this.innerHeight);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        scrollY = (int)((float)scrollY + MOMathHelper.Lerp(scrollX, scrollX + movement, 0.1f));
        scrollX = Math.min(scrollX, 0);
        scrollX = Math.max(scrollX, this.sizeX - this.innerWidth);
        scrollY = Math.min(scrollY, 0);
        scrollY = Math.max(scrollY, this.sizeY - this.innerHeight);
        return true;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.mouseIsDown = true;
        }
        return super.onMousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        if (this.mouseIsDown) {
            this.mouseIsDown = false;
        }
        super.onMouseReleased(mouseX, mouseY);
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        if (element instanceof ElementGuideEntry) {
            this.pageGuideDescription.OpenGuide(((ElementGuideEntry)element).getEntry().getId());
            MatterOverdrive.packetPipeline.sendToServer(new PacketDataPadCommands(this.dataPadStack));
            ((MOGuiBase)this.gui).setPage(1);
        } else if (element.equals((Object)this.orderButtonElement)) {
            MatterOverdriveItems.dataPad.setOrdering(this.dataPadStack, this.orderButtonElement.getSelectedState());
            MatterOverdrive.packetPipeline.sendToServer(new PacketDataPadCommands(this.dataPadStack));
        } else if (element instanceof ElementGuideCategory) {
            this.setActiveCategory(((ElementGuideCategory)element).getCategory().getName());
        }
    }

    public void setDataPadStack(ItemStack dataPadStack) {
        this.dataPadStack = dataPadStack;
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
        searchFilter = text;
    }

    public void setActiveCategory(String category) {
        MatterOverdriveItems.dataPad.setCategory(this.dataPadStack, category);
        MatterOverdrive.packetPipeline.sendToServer(new PacketDataPadCommands(this.dataPadStack));
        ((MOGuiBase)this.gui).setPage(0);
        this.groups.clear();
    }

    public GuideCategory getActiveCategory() {
        String category = MatterOverdriveItems.dataPad.getCategory(this.dataPadStack);
        GuideCategory cat = MatterOverdriveGuide.getCategory(category);
        if (cat == null) {
            return MatterOverdriveGuide.getCategory("general");
        }
        return cat;
    }

    public List<ElementGuideCategory> getCategories() {
        return this.categories;
    }

    static {
        searchFilter = "";
    }
}

