/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import cofh.lib.gui.GuiColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementAbstractStarMapEntry;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ElementPlanetEntry
extends ElementAbstractStarMapEntry<Planet> {
    public ElementPlanetEntry(GuiStarMap gui, ElementGroupList groupList, int width, int height, Planet spaceBody) {
        super(gui, groupList, width, height, spaceBody);
    }

    @Override
    protected void drawElementName(Planet planet, GuiColor color, float multiply) {
        String name = ((Planet)this.spaceBody).getName();
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(planet)) {
            name = "@ " + EnumChatFormatting.ITALIC + name;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || GalaxyClient.getInstance().canSeePlanetInfo(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            RenderUtils.drawString(name, this.posX + 16, this.posY + 10, color, multiply);
        } else {
            RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, name, this.posX + 16, this.posY + 10, color, multiply);
        }
    }

    @Override
    protected Map<HoloIcon, Integer> getIcons(Planet planet) {
        HashMap<HoloIcon, Integer> icons = new HashMap<HoloIcon, Integer>();
        HoloIcon shipIcon = ClientProxy.holoIcons.getIcon("icon_shuttle");
        icons.put(shipIcon, 0);
        if (planet.isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (planet.isHomeworld()) {
                icons.put(ClientProxy.holoIcons.getIcon("home_icon"), -1);
            }
            if (planet.getBuildings().size() > 0) {
                icons.put(ClientProxy.holoIcons.getIcon("factory"), planet.getBuildings().size());
            }
        }
        for (ItemStack ship : planet.getFleet()) {
            if (!((IShip)ship.func_77973_b()).isOwner(ship, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
            icons.put(shipIcon, icons.get(shipIcon) + 1);
            break;
        }
        return icons;
    }

    public void addTooltip(List<String> list) {
    }

    @Override
    protected boolean canTravelTo(Planet planet, EntityPlayer player) {
        return !((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getGalaxyPosition().equals(planet);
    }

    @Override
    protected boolean canView(Planet planet, EntityPlayer player) {
        if (planet.hasOwner()) {
            return planet.isOwner(player);
        }
        return true;
    }

    @Override
    public float getMultiply(Planet planet) {
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getDestination().equals(planet)) {
            return 1.0f;
        }
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(planet)) {
            return 0.5f;
        }
        return 0.1f;
    }

    @Override
    public ScaleTexture getBG(Planet planet) {
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(planet)) {
            return BG_MIDDLE_DOWN;
        }
        return BG;
    }

    @Override
    protected GuiColor getSpaceBodyColor(Planet planet) {
        return Planet.getGuiColor(planet);
    }

    @Override
    boolean isSelected(Planet planet) {
        return ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getDestination().equals(planet);
    }

    @Override
    protected void onViewPress() {
        ((GuiStarMap)this.gui).setPage(3);
    }

    @Override
    protected void onTravelPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setGalaxticPosition(new GalacticPosition((Planet)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }

    @Override
    protected void onSelectPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setDestination(new GalacticPosition((Planet)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }
}

