/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementGuideEntry
extends MOElementBase {
    public static final ResourceLocation BG = new ResourceLocation("mo:textures/gui/elements/quide_element_bg.png");
    private MOGuideEntry entry;
    private IButtonHandler buttonHandler;
    private boolean showLabel;

    public ElementGuideEntry(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY, MOGuideEntry entry) {
        super(gui, posX, posY);
        this.entry = entry;
        this.setSize(22, 22);
        this.buttonHandler = buttonHandler;
    }

    public void addTooltip(List<String> list) {
        list.add(this.entry.getDisplayName());
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(BG);
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, 22, 22, 22.0f, 22.0f);
    }

    public void drawForeground(int mouseX, int mouseY) {
        int iconIndex = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / 20L % (long)this.entry.getStackIcons().length);
        RenderUtils.renderStack(this.posX + 3, this.posY + 3, this.entry.getStackIcons()[iconIndex]);
        if (this.showLabel) {
            this.getFontRenderer().func_78264_a(true);
            this.getFontRenderer().func_78276_b(this.entry.getDisplayName(), this.posX + this.sizeX + 4, this.posY + this.sizeY / 2 - 5, Reference.COLOR_MATTER.getColor());
            this.getFontRenderer().func_78264_a(false);
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this.buttonHandler.handleElementButtonClick(this, this.name, mouseButton);
        return true;
    }

    public MOGuideEntry getEntry() {
        return this.entry;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }
}

