/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.render.RenderHelper;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.network.packet.server.PacketUnlockBioticStat;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;

public class ElementBioStat
extends MOElementButton {
    IBionicStat stat;
    AndroidPlayer player;
    int level;
    ForgeDirection direction;
    Cylinder cylinder;

    public ElementBioStat(MOGuiBase gui, int posX, int posY, IBionicStat stat, int level, AndroidPlayer player, ForgeDirection direction) {
        super(gui, gui, posX, posY, stat.getUnlocalizedName(), 0, 0, 0, 0, 22, 22, "");
        this.texture = ElementSlot.getTexture("holo");
        this.texW = 22;
        this.texH = 22;
        this.stat = stat;
        this.player = player;
        this.level = level;
        this.direction = direction;
        this.cylinder = new Cylinder();
    }

    public boolean isEnabled() {
        return this.stat.canBeUnlocked(this.player, this.level) && this.player.getUnlockedLevel(this.stat) < this.stat.maxLevel();
    }

    protected void ApplyColor() {
        if (this.stat.canBeUnlocked(this.player, this.level) || this.player.isUnlocked(this.stat, this.level)) {
            if (this.level <= 0) {
                RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.5f);
            } else {
                RenderUtils.applyColor(Reference.COLOR_HOLO);
            }
        } else {
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO_RED, 0.5f);
        }
    }

    protected void ResetColor() {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTooltip(List<String> list) {
        this.stat.onTooltip(this.player, this.level, list, this.gui.getMouseX(), this.gui.getMouseY());
    }

    @Override
    public void onAction(int mouseX, int mouseY, int mouseButton) {
        if (super.intersectsWith(mouseX, mouseY) && this.stat.canBeUnlocked(this.player, this.level + 1) && this.level < this.stat.maxLevel()) {
            GuiBase.playSound((String)"mo:gui.biotic_stat_unlock", (float)1.0f, (float)1.0f);
            MatterOverdrive.packetPipeline.sendToServer(new PacketUnlockBioticStat(this.stat.getUnlocalizedName(), ++this.level));
        }
        super.onAction(mouseX, mouseY, mouseButton);
    }

    public void drawTexturedModalRect(int var1, int var2, int var3, int var4, int var5, int var6) {
        this.ApplyColor();
        this.gui.drawSizedTexturedModalRect(var1, var2, var3, var4, var5, var6, (float)this.texW, (float)this.texH);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glEnable((int)3042);
        this.ApplyColor();
        super.drawBackground(mouseX, mouseY, gameTicks);
        this.drawIcon(this.stat.getIcon(this.level), this.posX + 3, this.posY + 3);
        if (this.direction != ForgeDirection.UNKNOWN) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.posX, (double)this.posY, (double)0.0);
            GL11.glTranslated((double)(this.sizeX / 2), (double)(this.sizeY / 2), (double)0.0);
            GL11.glTranslated((double)((double)this.direction.offsetX * ((double)this.sizeX * 0.75)), (double)((double)(-this.direction.offsetY) * ((double)this.sizeY * 0.75)), (double)0.0);
            if (this.direction == ForgeDirection.EAST) {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            } else if (this.direction == ForgeDirection.WEST) {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
            } else if (this.direction == ForgeDirection.DOWN) {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            }
            GL11.glTranslated((double)-3.5, (double)-3.5, (double)0.0);
            ClientProxy.holoIcons.renderIcon("up_arrow", 0, 0);
            GL11.glPopMatrix();
        }
        this.ResetColor();
        GL11.glDisable((int)3042);
    }

    public void drawForeground(int x, int y) {
        if (this.stat.maxLevel() > 1 && this.level > 0) {
            String levelInfo = Integer.toString(this.level);
            ClientProxy.holoIcons.renderIcon("black_circle", this.posX + 14, this.posY + 14, 10, 10);
            this.getFontRenderer().func_78276_b(levelInfo, this.posX + 16, this.posY + 16, 0xFFFFFF);
        }
    }

    public void drawIcon(IIcon icon, int x, int y) {
        if (icon != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            ClientProxy.holoIcons.bindSheet();
            RenderHelper.renderIcon((double)x, (double)y, (double)0.0, (IIcon)icon, (int)16, (int)16);
            GL11.glDisable((int)3042);
        }
    }

    public IBionicStat getStat() {
        return this.stat;
    }
}

