/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import cofh.lib.gui.GuiColor;
import matteroverdrive.Reference;
import matteroverdrive.data.MinimapEntityInfo;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.glu.Sphere;

public class AndroidHudMinimap
extends AndroidHudElement {
    private Sphere sphere = new Sphere();
    private Cylinder cylinder = new Cylinder();
    private final float OPACITY = 0.6f;
    private final int ROTATION = 55;
    private float ZOOM = 1.0f;
    private int RADIUS = 64;

    public AndroidHudMinimap(AndroidHudPosition position, String name) {
        super(position, name, 188, 188);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return android.isUnlocked(MatterOverdriveBioticStats.minimap, 0);
    }

    @Override
    public void drawElement(AndroidPlayer androidPlayer, int mouseX, int mouseY, ScaledResolution resolution, float ticks) {
        int x = this.getWidth(resolution) / 2;
        int y = this.getHeight(resolution) / 2;
        float scale = this.getScale(resolution);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glRotated((double)55.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.drawBackground(resolution);
        RenderUtils.beginStencil();
        this.drawStencil();
        GL11.glPopMatrix();
        for (Object entityObj : this.mc.field_71441_e.field_72996_f) {
            if (!(entityObj instanceof EntityLivingBase)) continue;
            EntityLivingBase entityLivingBase = (EntityLivingBase)entityObj;
            Vec3 pos = entityLivingBase.func_70666_h(ticks);
            Vec3 playerPosition = this.mc.field_71439_g.func_70666_h(ticks);
            pos = pos.func_72444_a(playerPosition);
            pos.field_72450_a *= (double)this.ZOOM;
            pos.field_72448_b *= (double)this.ZOOM;
            pos.field_72449_c *= (double)this.ZOOM;
            if (!AndroidPlayer.isVisibleOnMinimap((EntityLivingBase)entityObj, (EntityPlayer)this.mc.field_71439_g, pos) || !(pos.func_72433_c() < (double)Math.min(256.0f, (float)this.RADIUS + 16.0f / this.ZOOM))) continue;
            GL11.glPushMatrix();
            this.drawEntity(entityLivingBase, scale, x, y, pos);
            GL11.glPopMatrix();
        }
        RenderUtils.endStencil();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
    }

    private void drawStencil() {
        GL11.glDisable((int)3553);
        GL11.glStencilFunc((int)519, (int)1, (int)1);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)1);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        RenderUtils.drawCircle(this.RADIUS, 32);
        GL11.glEnable((int)3553);
        GL11.glStencilFunc((int)514, (int)1, (int)1);
        GL11.glStencilMask((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
    }

    private void drawBackground(ScaledResolution resolution) {
        this.drawCompas();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6913);
        GL11.glLineWidth((float)1.0f);
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.3f);
        RenderUtils.drawCircle(this.RADIUS, 32);
        this.drawFov(resolution);
        double radarPercent = (double)(this.mc.field_71441_e.func_72820_D() % 40L) / 40.0;
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.48000002f * (float)radarPercent);
        RenderUtils.drawCircle(radarPercent * (double)this.RADIUS, 32);
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.3f);
        GL11.glCullFace((int)1028);
        this.cylinder.draw((float)this.RADIUS, (float)this.RADIUS, 5.0f, 64, 1);
        GL11.glCullFace((int)1029);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glPushMatrix();
        this.drawPlayer();
        GL11.glPopMatrix();
    }

    private void drawCompas() {
        int rad = 74;
        this.mc.field_71466_p.func_78276_b("S", (int)(Math.sin(Math.toRadians(180.0f - this.mc.field_71451_h.field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(180.0f - this.mc.field_71451_h.field_70177_z)) * (double)rad), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("N", (int)(Math.sin(Math.toRadians(-this.mc.field_71451_h.field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(-this.mc.field_71451_h.field_70177_z)) * 64.0), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("E", (int)(Math.sin(Math.toRadians(90.0f - this.mc.field_71451_h.field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(90.0f - this.mc.field_71451_h.field_70177_z)) * (double)rad), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("W", (int)(Math.sin(Math.toRadians(-this.mc.field_71451_h.field_70177_z - 90.0f)) * (double)rad), (int)(Math.cos(Math.toRadians(-this.mc.field_71451_h.field_70177_z - 90.0f)) * (double)rad), Reference.COLOR_MATTER.getColor());
    }

    private void drawPlayer() {
        RenderUtils.applyColor(Reference.COLOR_HOLO_GREEN);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        RenderUtils.drawShip(0.0, 0.0, 0.0, 3.0);
    }

    private void drawFov(ScaledResolution resolution) {
        double aspectRatio = resolution.func_78327_c() / resolution.func_78324_d();
        float angleAdd = 180.0f;
        float fovAngle = this.mc.field_71474_y.field_74334_X * 0.5f * (float)aspectRatio;
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)(Math.sin(Math.toRadians(fovAngle + angleAdd)) * (double)this.RADIUS), (double)(Math.cos(Math.toRadians(fovAngle + angleAdd)) * (double)this.RADIUS), (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)(Math.sin(Math.toRadians(-fovAngle + angleAdd)) * (double)this.RADIUS), (double)(Math.cos(Math.toRadians(-fovAngle + angleAdd)) * (double)this.RADIUS), (double)0.0);
        GL11.glEnd();
    }

    private void drawEntity(EntityLivingBase entityLivingBase, float scale, int x, int y, Vec3 pos) {
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glRotated((double)55.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        if (!entityLivingBase.equals((Object)this.mc.field_71439_g)) {
            int size = this.getMinimapSize(entityLivingBase);
            GuiColor color = this.getMinimapColor(entityLivingBase);
            float opacity = this.mc.field_71439_g.func_70685_l((Entity)entityLivingBase) ? 1.0f : 0.7f;
            GL11.glEnable((int)3553);
            RenderUtils.applyColorWithAlpha(color, 0.6f * opacity);
            GL11.glRotated((double)this.mc.field_71451_h.field_70177_z, (double)0.0, (double)0.0, (double)-1.0);
            GL11.glTranslated((double)pos.field_72450_a, (double)pos.field_72449_c, (double)0.0);
            GL11.glRotated((double)entityLivingBase.func_70079_am(), (double)0.0, (double)0.0, (double)1.0);
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            RenderUtils.applyColorWithAlpha(color, 0.6f * opacity);
            RenderUtils.drawCircle(2.0, 18);
            if (Math.abs(pos.field_72448_b) > 4.0) {
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
                GL11.glVertex3d((double)0.0, (double)0.0, (double)pos.field_72448_b);
                GL11.glEnd();
                GL11.glTranslated((double)0.0, (double)0.0, (double)pos.field_72448_b);
                this.sphere.draw(2.0f * opacity, 6, 6);
            }
            GL11.glPopMatrix();
            RenderUtils.applyColorWithAlpha(color, 0.120000005f * opacity);
            RenderUtils.drawCircle(size, 18);
        }
    }

    private int getMinimapSize(EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof IMob && entityLivingBase instanceof EntityCreature) {
            return 17;
        }
        return 4;
    }

    private GuiColor getMinimapColor(EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof IMob) {
            MinimapEntityInfo entityInfo = AndroidPlayer.getMinimapEntityInfo(entityLivingBase);
            if (entityInfo != null && entityInfo.isAttacking()) {
                return Reference.COLOR_GUI_ENERGY;
            }
            return Reference.COLOR_HOLO_RED;
        }
        if (entityLivingBase instanceof EntityPlayer) {
            return Reference.COLOR_HOLO_YELLOW;
        }
        if (entityLivingBase instanceof IMerchant) {
            return Reference.COLOR_HOLO_GREEN;
        }
        return Reference.COLOR_HOLO;
    }

    private float getScale(ScaledResolution resolution) {
        return 1.5f - 0.2f * (float)resolution.func_78325_e();
    }

    @Override
    public int getWidth(ScaledResolution resolution) {
        return (int)((float)this.width * this.getScale(resolution));
    }

    @Override
    public int getHeight(ScaledResolution resolution) {
        return (int)((float)this.height * this.getScale(resolution));
    }
}

