/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.element.ElementBase;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.container.ContainerMatterScanner;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementGuideCategory;
import matteroverdrive.gui.pages.PageGuideDescription;
import matteroverdrive.gui.pages.PageGuideEntries;
import matteroverdrive.guide.GuideCategory;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiDataPad
extends MOGuiBase {
    public static final ResourceLocation BG = new ResourceLocation("mo:textures/gui/pad.png");
    PageGuideDescription guideDescription;
    PageGuideEntries guideEntries;
    ItemStack dataPad;

    public GuiDataPad(ItemStack dataPadStack) {
        super(new ContainerMatterScanner(), 300, 260);
        this.background = new ScaleTexture(BG, 93, 115).setOffsets(46, 46, 40, 73);
        this.dataPad = dataPadStack;
        this.setPage(MatterOverdriveItems.dataPad.getPage(dataPadStack));
        this.guideEntries.setDataPadStack(dataPadStack);
        this.guideDescription.setDataPadStack(dataPadStack);
    }

    @Override
    public void registerPages(MOBaseContainer container) {
        this.guideDescription = new PageGuideDescription(this, 14, 14, this.field_146999_f - 28, this.field_147000_g - 14 - 49, "Guide Description");
        this.guideEntries = new PageGuideEntries(this, 14, 14, this.field_146999_f - 28, this.field_147000_g - 14 - 49, "Guide Entries", this.guideDescription);
        this.AddPage(this.guideEntries, ClientProxy.holoIcons.getIcon("page_icon_home"), "Guide Entries");
        this.AddPage(this.guideDescription, ClientProxy.holoIcons.getIcon("page_icon_search"), MOStringHelper.translateToLocal("gui.tooltip.page.info_database"));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.elements.remove(this.sidePannel);
        this.closeButton.setPosition(this.field_146999_f - 32, 20);
        for (ElementGuideCategory category : this.guideEntries.getCategories()) {
            this.addElement((ElementBase)category);
        }
    }

    @Override
    public void onPageChange(int newPage) {
        if (newPage != MatterOverdriveItems.dataPad.getPage(this.dataPad)) {
            MatterOverdriveItems.dataPad.setOpenPage(this.dataPad, newPage);
            MatterOverdrive.packetPipeline.sendToServer(new PacketDataPadCommands(this.dataPad));
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        GuideCategory category = this.guideEntries.getActiveCategory();
        for (int i = 0; i < this.guideEntries.getCategories().size(); ++i) {
            if (category.equals(this.guideEntries.getCategories().get(i).getCategory())) {
                this.guideEntries.getCategories().get(i).setEnabled(false);
            } else {
                this.guideEntries.getCategories().get(i).setEnabled(true);
            }
            this.guideEntries.getCategories().get(i).setPosition(16 + 32 * i, this.field_147000_g - 28);
        }
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }

    public PageGuideDescription getGuideDescription() {
        return this.guideDescription;
    }
}

