/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.container.ContainerAndroidStation;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.data.inventory.BionicSlot;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.entity.EntityRougeAndroidMob;
import matteroverdrive.gui.GuiConfig;
import matteroverdrive.gui.GuiWeaponStation;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementBioStat;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.TileEntityAndroidStation;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiAndroidStation
extends MOGuiMachine<TileEntityAndroidStation> {
    private EntityRougeAndroidMob mob;
    private MOElementButtonScaled hudConfigs;
    ElementSlot[] parts_slots = new ElementSlot[6];
    List<ElementBioStat> stats = new ArrayList<ElementBioStat>(MatterOverdrive.statRegistry.getStats().size());

    public GuiAndroidStation(InventoryPlayer inventoryPlayer, TileEntityAndroidStation machine) {
        super(new ContainerAndroidStation(inventoryPlayer, machine), machine, 364, 250);
        this.texW = 255;
        this.texH = 237;
        AndroidPlayer androidPlayer = AndroidPlayer.get(inventoryPlayer.field_70458_d);
        this.background = GuiWeaponStation.BG;
        for (int i = 0; i < this.parts_slots.length; ++i) {
            this.parts_slots[i] = new ElementInventorySlot((GuiBase)this, (MOSlot)this.field_147002_h.func_75139_a(i), 20, 20, "holo", androidPlayer.getInventory().getSlot(i).getHoloIcon());
            this.parts_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
            this.parts_slots[i].setInfo("biopart." + BionicSlot.names[i] + ".name");
        }
        this.parts_slots[0].setPosition(220, this.field_147000_g - 110);
        this.parts_slots[1].setPosition(220, this.field_147000_g - 80);
        this.parts_slots[2].setPosition(220, this.field_147000_g - 50);
        this.parts_slots[3].setPosition(320, this.field_147000_g - 110);
        this.parts_slots[4].setPosition(320, this.field_147000_g - 80);
        this.parts_slots[5].setPosition(320, this.field_147000_g - 50);
        this.parts_slots[5].setIcon(ClientProxy.holoIcons.getIcon("battery"));
        this.addStat(androidPlayer, MatterOverdriveBioticStats.teleport, 0, 0, ForgeDirection.UNKNOWN);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.nanobots, 1, 1, ForgeDirection.UNKNOWN);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.nanoArmor, 0, 1, ForgeDirection.EAST);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.flotation, 2, 0, ForgeDirection.UNKNOWN);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.speed, 3, 0, ForgeDirection.UNKNOWN);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.highJump, 3, 1, ForgeDirection.UP);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.equalizer, 3, 2, ForgeDirection.UP);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.shield, 0, 2, ForgeDirection.UP);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.attack, 2, 1, ForgeDirection.WEST);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.cloak, 0, 3, ForgeDirection.UP);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.nightvision, 1, 0, ForgeDirection.UNKNOWN);
        this.addStat(androidPlayer, MatterOverdriveBioticStats.minimap, 1, 2, ForgeDirection.UNKNOWN);
        this.mob = new EntityRougeAndroidMob((World)Minecraft.func_71410_x().field_71441_e);
        this.mob.getEntityData().func_74757_a("Hologram", true);
        this.hudConfigs = new MOElementButtonScaled(this, this, 48, 64, "hud_configs", 128, 24);
        this.hudConfigs.setText("HUD Options");
    }

    public void addStat(AndroidPlayer androidPlayer, IBionicStat stat, int x, int y, ForgeDirection direction) {
        ElementBioStat elemStat = new ElementBioStat(this, 0, 0, stat, androidPlayer.getUnlockedLevel(stat), androidPlayer, direction);
        elemStat.setPosition(54 + x * 30, 36 + y * 30);
        this.stats.add(elemStat);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (ElementSlot elementSlot : this.parts_slots) {
            ((ElementBaseGroup)this.pages.get(0)).addElement(elementSlot);
        }
        for (ElementBioStat stat : this.stats) {
            ((ElementBaseGroup)this.pages.get(0)).addElement((ElementBase)stat);
        }
        ((ElementBaseGroup)this.pages.get(1)).addElement((ElementBase)this.hudConfigs);
        this.AddMainPlayerSlots(this.field_147002_h, this);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    public void drawTooltip(List<String> list) {
        for (ElementBioStat stat : this.stats) {
            if (!stat.intersectsWith(this.mouseX, this.mouseY)) continue;
            int itemCount = 0;
            for (ItemStack stack : stat.getStat().getRequiredItems()) {
                int x = this.field_147003_i + this.mouseX + 12 + 22 * itemCount;
                int y = this.field_147009_r + this.mouseY - 36;
                RenderUtils.renderStack(x, y, stack);
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
                this.field_146289_q.func_78276_b(Integer.toString(stack.field_77994_a), x + 13, y + 8, 0xFFFFFF);
                GL11.glPopMatrix();
                ++itemCount;
            }
        }
        super.drawTooltip(list);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            this.drawEntityOnScreen(280, this.field_147000_g - 25, 50, -this.mouseX + 280, -this.mouseY + this.field_147000_g - 100, (EntityPlayer)this.field_146297_k.field_71439_g);
            GL11.glPopMatrix();
            String info = Minecraft.func_71410_x().field_71439_g.field_71068_ca + " XP";
            GL11.glDisable((int)2896);
            int width = this.field_146289_q.func_78256_a(info);
            this.field_146289_q.func_78276_b(EnumChatFormatting.GREEN + info, 280 - width / 2, this.field_147000_g - 20, 0xFFFFFF);
        }
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String elementName, int mouseButton) {
        super.handleElementButtonClick(element, elementName, mouseButton);
        if (element.equals((Object)this.hudConfigs)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfig((GuiScreen)this, "client.android_hud"));
        }
    }

    private void drawEntityOnScreen(int x, int y, int scale, float mouseX, float mouseY, EntityPlayer entity) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        entity.field_70761_aq = this.field_146297_k.field_71441_e.func_72820_D();
        entity.field_70177_z = this.field_146297_k.field_71441_e.func_72820_D();
        entity.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }
}

