/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import cofh.lib.gui.GuiColor;
import cofh.lib.render.RenderHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.animation.AnimationSegmentText;
import matteroverdrive.animation.AnimationTextTyping;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.api.inventory.IEnergyPack;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.gui.GuiDialog;
import matteroverdrive.gui.android.AndroidHudBionicStats;
import matteroverdrive.gui.android.AndroidHudMinimap;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.gui.android.AndroidHudStats;
import matteroverdrive.gui.android.IAndroidHudElement;
import matteroverdrive.gui.config.EnumConfigProperty;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.util.JsonException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Property;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAndroidHud
extends Gui
implements IConfigSubscriber {
    public static final ResourceLocation glitch_tex = new ResourceLocation("mo:textures/gui/glitch.png");
    public static final ResourceLocation spinner_tex = new ResourceLocation("mo:textures/gui/elements/spinner.png");
    public static final ResourceLocation top_element_bg = new ResourceLocation("mo:textures/gui/elements/android_bg_element.png");
    public static final ResourceLocation cloak_overlay = new ResourceLocation("mo:textures/gui/elements/cloak_overlay.png");
    private AnimationTextTyping textTyping;
    private Minecraft mc;
    private Random random;
    private ShaderGroup hurtShader;
    private List<IBionicStat> stats = new ArrayList<IBionicStat>();
    public static boolean showRadial = false;
    public static double radialDeltaX;
    public static double radialDeltaY;
    public static double radialAngle;
    private static double radialAnimationTime;
    private IIcon crosshairIcon;
    private List<IAndroidHudElement> hudElements;
    public final AndroidHudMinimap hudMinimap;
    public final AndroidHudStats hudStats;
    public final AndroidHudBionicStats bionicStats;
    public GuiColor baseGuiColor;
    public float opacity;
    public static float hudRotationYawSmooth;
    public static float hudRotationPitchSmooth;

    public GuiAndroidHud(Minecraft mc) {
        String info;
        this.mc = mc;
        this.random = new Random();
        this.textTyping = new AnimationTextTyping(false, 680);
        for (int i = 0; i < 5; ++i) {
            info = MOStringHelper.translateToLocal("gui.android_hud.transforming.line." + i);
            this.textTyping.addSeqmentSequential(new AnimationSegmentText(info, 0, 1).setLengthPerCharacter(2));
            this.textTyping.addSeqmentSequential(new AnimationSegmentText(info, 0, 0).setLengthPerCharacter(2));
        }
        info = MOStringHelper.translateToLocal("gui.android_hud.transforming.line.final");
        this.textTyping.addSeqmentSequential(new AnimationSegmentText(info, 0, 1).setLengthPerCharacter(2));
        this.textTyping.addSeqmentSequential(new AnimationSegmentText(info, 680, 0));
        this.hudElements = new ArrayList<IAndroidHudElement>();
        this.hudMinimap = new AndroidHudMinimap(AndroidHudPosition.BOTTOM_LEFT, "android_minimap");
        this.hudStats = new AndroidHudStats(AndroidHudPosition.TOP_LEFT, "android_stats");
        this.bionicStats = new AndroidHudBionicStats(AndroidHudPosition.TOP_RIGHT, "android_biotic_stats");
        this.hudElements.add(this.hudMinimap);
        this.hudElements.add(this.hudStats);
        this.hudElements.add(this.bionicStats);
        this.baseGuiColor = Reference.COLOR_HOLO.multiply(0.5f);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (showRadial) {
            Mouse.getDX();
            Mouse.getDY();
            this.mc.field_71417_B.field_74375_b = 0;
            this.mc.field_71417_B.field_74377_a = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        AndroidPlayer android = AndroidPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiDialog && !event.type.equals((Object)RenderGameOverlayEvent.ElementType.ALL) && event.isCancelable()) {
            event.setCanceled(true);
            return;
        }
        if (android.isAndroid() && (event.type == RenderGameOverlayEvent.ElementType.FOOD || event.type == RenderGameOverlayEvent.ElementType.AIR || event.type == RenderGameOverlayEvent.ElementType.HEALTH)) {
            event.setCanceled(true);
            return;
        }
        if (android.isAndroid() && event.isCancelable() && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (!showRadial) {
                this.renderCrosshair(event);
            }
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        this.renderHud(event);
        if (android.isAndroid() && (radialAnimationTime = showRadial ? Math.min(1.0, radialAnimationTime + (double)event.partialTicks * 0.2) : Math.max(0.0, radialAnimationTime - (double)event.partialTicks * 0.2)) > 0.0) {
            this.renderRadialMenu(event);
        }
    }

    public void renderCrosshair(RenderGameOverlayEvent event) {
        GL11.glPushMatrix();
        float scale = 8.0f + ClientProxy.weaponHandler.getEquippedWeaponHeatPercent((EntityPlayer)Minecraft.func_71410_x().field_71439_g) * 16.0f;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)775, (int)0);
        GL11.glEnable((int)3008);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        this.crosshairIcon = ClientProxy.holoIcons.getIcon("crosshair").getIcon();
        GL11.glTranslated((double)(event.resolution.func_78326_a() / 2), (double)(event.resolution.func_78328_b() / 2), (double)0.0);
        GL11.glPushMatrix();
        ClientProxy.holoIcons.bindSheet();
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        RenderHelper.renderIcon((double)-1.5, (double)(-scale), (double)0.0, (IIcon)this.crosshairIcon, (int)3, (int)3);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        RenderHelper.renderIcon((double)-1.5, (double)(-scale), (double)0.0, (IIcon)this.crosshairIcon, (int)3, (int)3);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        RenderHelper.renderIcon((double)-1.5, (double)(-scale), (double)0.0, (IIcon)this.crosshairIcon, (int)3, (int)3);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        RenderHelper.renderIcon((double)-1.5, (double)(-scale), (double)0.0, (IIcon)this.crosshairIcon, (int)3, (int)3);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void renderRadialMenu(RenderGameOverlayEvent event) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(event.resolution.func_78326_a() / 2), (double)(event.resolution.func_78328_b() / 2), (double)0.0);
        double scale = MOMathHelper.easeIn(radialAnimationTime, 0.0, 1.0, 1.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        ClientProxy.holoIcons.bindSheet();
        AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.stats.clear();
        for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
            if (!stat.showOnWheel(androidPlayer, androidPlayer.getUnlockedLevel(stat)) || !androidPlayer.isUnlocked(stat, 0)) continue;
            this.stats.add(stat);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        GL11.glRotated((double)radialAngle, (double)0.0, (double)0.0, (double)-1.0);
        RenderUtils.applyColorWithMultipy(this.baseGuiColor, 0.4f);
        ClientProxy.holoIcons.renderIcon("up_arrow_large", -9, -50);
        GL11.glPopMatrix();
        int i = 0;
        for (IBionicStat stat : this.stats) {
            double angleCircle;
            double angleAb;
            int c;
            double angleSeg = Math.PI * 2 / (double)this.stats.size();
            double radius = 80.0;
            double angle = angleSeg * (double)i;
            angle += Math.toRadians(180.0);
            double radiusMin = radius - 16.0;
            double radiusMax = radius + 16.0;
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (androidPlayer.getActiveStat() != null && androidPlayer.getActiveStat().equals(stat)) {
                radiusMax = radius + 20.0;
                radiusMin = radius - 16.0;
                GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.6);
            } else {
                GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.4);
            }
            Tessellator.field_78398_a.func_78382_b();
            for (c = 0; c < 32; ++c) {
                angleAb = angleSeg / 32.0;
                angleCircle = (double)c * angleAb + angle - angleSeg / 2.0;
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle) * radiusMax, Math.cos(angleCircle) * radiusMax, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle + angleAb) * radiusMax, Math.cos(angleCircle + angleAb) * radiusMax, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle + angleAb) * radiusMin, Math.cos(angleCircle + angleAb) * radiusMin, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle) * radiusMin, Math.cos(angleCircle) * radiusMin, -1.0);
            }
            Tessellator.field_78398_a.func_78381_a();
            radiusMax = radius - 20.0;
            radiusMin = radius - 25.0;
            Tessellator.field_78398_a.func_78382_b();
            GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.2);
            for (c = 0; c < 32; ++c) {
                angleAb = 0.19634954084936207;
                angleCircle = (double)c * angleAb;
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle) * radiusMax, Math.cos(angleCircle) * radiusMax, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle + angleAb) * radiusMax, Math.cos(angleCircle + angleAb) * radiusMax, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle + angleAb) * radiusMin, Math.cos(angleCircle + angleAb) * radiusMin, -1.0);
                Tessellator.field_78398_a.func_78377_a(Math.sin(angleCircle) * radiusMin, Math.cos(angleCircle) * radiusMin, -1.0);
            }
            Tessellator.field_78398_a.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)false);
            ClientProxy.holoIcons.bindSheet();
            if (androidPlayer.getActiveStat() != null) {
                double y;
                double x;
                if (androidPlayer.getActiveStat().equals(stat)) {
                    RenderUtils.applyColorWithMultipy(this.baseGuiColor, 1.0f);
                    x = Math.sin(angle) * radius;
                    y = Math.cos(angle) * radius;
                    RenderHelper.renderIcon((double)(-12.0 + x), (double)(-12.0 + y), (double)10.0, (IIcon)stat.getIcon(0), (int)24, (int)24);
                    String statName = stat.getDisplayName(androidPlayer, androidPlayer.getUnlockedLevel(stat));
                    int statNameWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(statName);
                    GL11.glBlendFunc((int)770, (int)771);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(statName, -statNameWidth / 2, -5, this.baseGuiColor.getColor());
                } else {
                    x = Math.sin(angle) * radius;
                    y = Math.cos(angle) * radius;
                    RenderUtils.applyColorWithMultipy(this.baseGuiColor, 0.2f);
                    RenderHelper.renderIcon((double)(-12.0 + x), (double)(-12.0 + y), (double)10.0, (IIcon)stat.getIcon(0), (int)24, (int)24);
                }
            }
            ++i;
        }
        GL11.glPopMatrix();
    }

    public void renderHud(RenderGameOverlayEvent event) {
        AndroidPlayer android = AndroidPlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (android != null) {
            if (android.isAndroid()) {
                GL11.glPushMatrix();
                if (MatterOverdriveBioticStats.cloak.isActive(android, 0)) {
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)774, (int)0);
                    this.mc.field_71446_o.func_110577_a(cloak_overlay);
                    GuiAndroidHud.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)event.resolution.func_78326_a(), (int)event.resolution.func_78328_b(), (float)event.resolution.func_78326_a(), (float)event.resolution.func_78328_b());
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glDisable((int)3008);
                hudRotationYawSmooth = hudRotationYawSmooth * 0.4f + this.mc.field_71439_g.field_70177_z * 0.6f;
                hudRotationPitchSmooth = hudRotationPitchSmooth * 0.4f + this.mc.field_71439_g.field_70125_A * 0.6f;
                GL11.glTranslated((double)((hudRotationYawSmooth - this.mc.field_71439_g.field_70177_z) * 6.0f), (double)((hudRotationPitchSmooth - this.mc.field_71439_g.field_70125_A) * 6.0f), (double)0.0);
                for (IAndroidHudElement element : this.hudElements) {
                    if (!element.isVisible(android)) continue;
                    GL11.glPushMatrix();
                    int elementWidth = (int)((float)element.getWidth(event.resolution) * element.getPosition().x);
                    GL11.glTranslated((double)((double)element.getPosition().x * event.resolution.func_78327_c() - (double)elementWidth), (double)((double)element.getPosition().y * event.resolution.func_78324_d() - (double)((float)element.getHeight(event.resolution) * element.getPosition().y)), (double)0.0);
                    element.setBaseColor(this.baseGuiColor);
                    element.drawElement(android, event.mouseX, event.mouseY, event.resolution, event.partialTicks);
                    GL11.glPopMatrix();
                }
                ClientProxy.holoIcons.bindSheet();
                if (android.getPlayer().func_70694_bm() != null && android.getPlayer().func_70694_bm().func_77973_b() instanceof IWeapon) {
                    this.renderWeaponHud(event, (IWeapon)android.getPlayer().func_70694_bm().func_77973_b(), android.getPlayer().func_70694_bm(), this.baseGuiColor);
                }
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glEnable((int)3008);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                this.renderHurt(android, event);
            } else if (android.isTurning()) {
                this.renderTransformAnimation(android, event);
            }
        }
    }

    private void renderWeaponHud(RenderGameOverlayEvent event, IWeapon weapon, ItemStack weaponStack, GuiColor color) {
        int x = 12;
        int y = 44;
        float percent = (float)weapon.getAmmo(weaponStack) / (float)weapon.getMaxAmmo(weaponStack);
        GuiColor lerpedColor = RenderUtils.lerp(Reference.COLOR_HOLO_RED, color, percent);
        RenderUtils.applyColorWithAlpha(lerpedColor);
        ClientProxy.holoIcons.renderIcon("ammo", x, y);
        String info = DecimalFormat.getPercentInstance().format(percent);
        this.mc.field_71466_p.func_78276_b(info, x += 18, y + 4, lerpedColor.getColor());
        x += this.mc.field_71466_p.func_78256_a(info);
        int energyPackCount = 0;
        for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyPack)) continue;
            energyPackCount += stack.field_77994_a;
        }
        info = " | " + Integer.toString(energyPackCount);
        this.mc.field_71466_p.func_78276_b(info, x, y + 4, color.getColor());
        x += 4 + this.mc.field_71466_p.func_78256_a(info);
        if (weapon.getMaxHeat(weaponStack) > 0.0f) {
            percent = weapon.getHeat(weaponStack) / weapon.getMaxHeat(weaponStack);
            lerpedColor = RenderUtils.lerp(Reference.COLOR_HOLO_RED, color, 1.0f - percent);
            RenderUtils.applyColorWithAlpha(lerpedColor);
            ClientProxy.holoIcons.renderIcon("temperature", x, y);
            info = DecimalFormat.getPercentInstance().format(percent);
            this.mc.field_71466_p.func_78276_b(info, x += 18, y + 4, lerpedColor.getColor());
        }
    }

    private void renderTransformAnimation(AndroidPlayer player, RenderGameOverlayEvent event) {
        int centerX = event.resolution.func_78326_a() / 2;
        int centerY = event.resolution.func_78328_b() / 2;
        int maxTime = 680;
        int time = maxTime - player.getEffects().func_74762_e("Turning");
        this.textTyping.setTime(time);
        if (time % 40 > 0 && time % 40 < 3) {
            this.renderGlitch(player, event);
        }
        String info = this.textTyping.getString();
        int width = this.mc.field_71466_p.func_78256_a(info);
        this.mc.field_71466_p.func_78276_b(info, centerX - width / 2, centerY - 28, Reference.COLOR_HOLO.getColor());
        this.mc.field_71446_o.func_110577_a(spinner_tex);
        GL11.glPushMatrix();
        GL11.glTranslated((double)centerX, (double)centerY, (double)0.0);
        GL11.glRotated((double)(this.mc.field_71441_e.func_72820_D() * 10L), (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)-16.0, (double)-16.0, (double)0.0);
        GuiAndroidHud.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GL11.glPopMatrix();
        this.mc.field_71466_p.func_78276_b(Math.round(this.textTyping.getPercent() * 100.0) + "%", centerX - 6, centerY - 3, Reference.COLOR_HOLO.getColor());
        if (!Minecraft.func_71410_x().field_71460_t.func_147702_a()) {
            this.createHurtShader();
            this.bindHurtShader();
        }
    }

    public void renderHurt(AndroidPlayer player, RenderGameOverlayEvent event) {
        if (player.getEffects().func_74762_e("GlitchTime") > 0) {
            this.renderGlitch(player, event);
            if (!Minecraft.func_71410_x().field_71460_t.func_147702_a()) {
                this.createHurtShader();
                this.bindHurtShader();
            }
        } else {
            this.disableHurtShader();
        }
    }

    private void createHurtShader() {
        if (this.hurtShader == null && Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            try {
                this.hurtShader = new ShaderGroup(Minecraft.func_71410_x().func_110434_K(), Minecraft.func_71410_x().func_110442_L(), Minecraft.func_71410_x().func_147110_a(), new ResourceLocation("shaders/post/deconverge.json"));
            }
            catch (JsonException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindHurtShader() {
        if (this.hurtShader != null && Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            Minecraft.func_71410_x().field_71460_t.field_147707_d = this.hurtShader;
            this.hurtShader.func_148026_a(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        }
    }

    private void disableHurtShader() {
        if (Minecraft.func_71410_x().field_71460_t.field_147707_d != null && Minecraft.func_71410_x().field_71460_t.field_147707_d == this.hurtShader) {
            Minecraft.func_71410_x().field_71460_t.field_147707_d = null;
        }
    }

    public void renderGlitch(AndroidPlayer player, RenderGameOverlayEvent event) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        this.mc.field_71446_o.func_110577_a(glitch_tex);
        GuiAndroidHud.func_146110_a((int)0, (int)0, (float)this.random.nextInt(1280), (float)this.random.nextInt(720), (int)event.resolution.func_78326_a(), (int)event.resolution.func_78328_b(), (float)event.resolution.func_78326_a(), (float)event.resolution.func_78328_b());
        GL11.glDisable((int)3042);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        Property prop = config.config.get("client.android_hud", this.hudMinimap.getName() + ".position", this.hudMinimap.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.minimap.position");
        this.hudMinimap.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        prop = config.config.get("client.android_hud", this.hudStats.getName() + ".position", this.hudStats.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.stats.position");
        this.hudStats.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        prop = config.config.get("client.android_hud", this.bionicStats.getName() + ".position", this.bionicStats.getDefaultPosition().ordinal());
        prop.setConfigEntryClass(EnumConfigProperty.class);
        prop.setValidValues(AndroidHudPosition.getNames());
        prop.setLanguageKey("config.android_hud.bionicStats.position");
        this.bionicStats.setHudPosition(AndroidHudPosition.values()[prop.getInt()]);
        GuiColor color = Reference.COLOR_HOLO;
        prop = config.config.get("client.android_hud", "hud_color", Integer.toHexString(color.getColor()));
        prop.setLanguageKey("config.android_hud.color");
        try {
            this.baseGuiColor = new GuiColor(Integer.parseInt(prop.getString(), 16));
        }
        catch (Exception e) {
            this.baseGuiColor = Reference.COLOR_HOLO;
        }
        prop = config.config.get("client.android_hud", "hud_opacity", 0.5, "The Opacity of the HUD in %", 0.0, 1.0);
        prop.setLanguageKey("config.android_hud.opacity");
        this.baseGuiColor = new GuiColor(this.baseGuiColor.getIntR(), this.baseGuiColor.getIntG(), this.baseGuiColor.getIntB(), (int)(255.0 * prop.getDouble()));
    }
}

