/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import cpw.mods.fml.relauncher.Side;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.dialog.IDialogRegistry;
import matteroverdrive.client.render.conversation.DialogShot;
import matteroverdrive.dialog.DialogMessage;
import matteroverdrive.dialog.DialogMessageAndroidTransformation;
import matteroverdrive.dialog.DialogMessageRandom;
import matteroverdrive.dialog.DialogMessageTrade;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.entity.tasks.EntityAITalkToPlayer;
import matteroverdrive.entity.tasks.EntityAIWatchDialogPlayer;
import matteroverdrive.init.MatterOverdriveDialogs;
import matteroverdrive.network.packet.server.PacketManageConversation;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityVillagerMadScientist
extends EntityVillager
implements IDialogNpc {
    private static DialogMessageRandom mainHumanMessage;
    private static DialogMessageRandom mainAndroidMessage;
    private EntityPlayer dialogPlayer;

    public EntityVillagerMadScientist(World world) {
        super(world, 666);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITalkToPlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchDialogPlayer(this));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        return p_110161_1_;
    }

    public EntityVillager func_90011_a(EntityAgeable p_90011_1_) {
        EntityVillagerMadScientist entityvillager = new EntityVillagerMadScientist(this.field_70170_p);
        entityvillager.func_110161_a(null);
        return entityvillager;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            MatterOverdrive.packetPipeline.sendToServer(new PacketManageConversation(this, true));
            return true;
        }
        return false;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        return super.func_70934_b(player);
    }

    public static void registerDialogMessages(IDialogRegistry registry, Side side) {
        DialogMessageAndroidTransformation convertMe = new DialogMessageAndroidTransformation("");
        convertMe.loadQuestionFromLocalization("dialog.mad_scientist.convert.question");
        DialogMessage canYouConvert = new DialogMessage("");
        canYouConvert.loadMessageFromLocalization("dialog.mad_scientist.requirements.line");
        canYouConvert.loadQuestionFromLocalization("dialog.mad_scientist.requirements.question");
        canYouConvert.addOption(convertMe);
        canYouConvert.addOption(MatterOverdriveDialogs.backMessage);
        mainHumanMessage = new DialogMessageRandom("");
        mainHumanMessage.loadMessageFromLocalization("dialog.mad_scientist.main.line.human");
        mainHumanMessage.addOption(canYouConvert);
        mainHumanMessage.addOption(MatterOverdriveDialogs.quitMessage);
        DialogMessageTrade trade = new DialogMessageTrade("");
        trade.loadQuestionFromLocalization("dialog.generic.trade.questions");
        DialogMessage undo = new DialogMessage("");
        undo.loadMessageFromLocalization("dialog.mad_scientist.undo.line");
        undo.loadQuestionFromLocalization("dialog.mad_scientist.undo.question");
        undo.addOption(trade);
        undo.addOption(MatterOverdriveDialogs.backMessage);
        DialogMessage whatDidYouDo = new DialogMessage("");
        whatDidYouDo.loadMessageFromLocalization("dialog.mad_scientist.whatDidYouDo.line");
        whatDidYouDo.loadQuestionFromLocalization("dialog.mad_scientist.whatDidYouDo.question");
        whatDidYouDo.addOption(undo);
        whatDidYouDo.addOption(MatterOverdriveDialogs.backMessage);
        mainAndroidMessage = new DialogMessageRandom("");
        mainAndroidMessage.loadMessageFromLocalization("dialog.mad_scientist.main.line.android");
        mainAndroidMessage.addOption(whatDidYouDo);
        mainAndroidMessage.addOption(trade);
        mainAndroidMessage.addOption(MatterOverdriveDialogs.quitMessage);
        whatDidYouDo.setParent(mainAndroidMessage);
        undo.setParent(whatDidYouDo);
        canYouConvert.setParent(mainHumanMessage);
        convertMe.setParent(canYouConvert);
        trade.setParent(mainAndroidMessage);
        if (side == Side.CLIENT) {
            trade.setHoloIcon("trade");
            canYouConvert.setShots(DialogShot.closeUp);
            undo.setShots(DialogShot.closeUp);
            whatDidYouDo.setShots(DialogShot.fromBehindLeftClose);
        }
    }

    @Override
    public IDialogMessage getStartDialogMessage(EntityPlayer player) {
        if (AndroidPlayer.get(player).isAndroid()) {
            return mainAndroidMessage;
        }
        return mainHumanMessage;
    }

    @Override
    public void setDialogPlayer(EntityPlayer player) {
        this.dialogPlayer = player;
    }

    @Override
    public EntityPlayer getDialogPlayer() {
        return this.dialogPlayer;
    }

    @Override
    public boolean canTalkTo(EntityPlayer player) {
        return AndroidPlayer.get(player) == null || !AndroidPlayer.get(player).isTurning();
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public boolean onPlayerInteract(EntityPlayer player) {
        return true;
    }
}

