/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.network.packet.server.PacketTeleportPlayer;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOPhysicsHelper;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fluids.IFluidBlock;

public class BioticStatTeleport
extends AbstractBioticStat
implements IConfigSubscriber {
    public static final String EFFECT_KEY_LAST_TELEPORT = "LastTeleport";
    public static final int TELEPORT_DELAY = 40;
    public static int ENERGY_PER_TELEPORT = 4096;
    public static int MAX_TELEPORT_HEIGHT_CHECK = 8;
    public static int MAX_TELEPORT_DISTANCE = 32;
    private HashSet<String> blackListedBlocks;
    @SideOnly(value=Side.CLIENT)
    private boolean hasPressedKey;

    public BioticStatTeleport(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setShowOnWheel(true);
        this.blackListedBlocks = new HashSet();
    }

    @Override
    public String getDetails(int level) {
        String keyName = GameSettings.func_74298_c((int)ClientProxy.keyHandler.getBinding(1).func_151463_i());
        return String.format(super.getDetails(level), keyName, EnumChatFormatting.YELLOW.toString() + ENERGY_PER_TELEPORT + " RF" + EnumChatFormatting.GRAY);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getPlayer().field_70170_p.field_72995_K) {
            this.manageActivate(android);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageActivate(AndroidPlayer androidPlayer) {
        if (ClientProxy.keyHandler.getBinding(1).func_151470_d() && androidPlayer.getActiveStat() != null && androidPlayer.getActiveStat().equals(this)) {
            this.hasPressedKey = true;
        } else if (this.hasPressedKey) {
            Vec3 pos = this.getPos(androidPlayer);
            if (pos != null) {
                MatterOverdrive.packetPipeline.sendToServer(new PacketTeleportPlayer(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c));
                this.hasPressedKey = false;
            }
            this.hasPressedKey = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    public Vec3 getPos(AndroidPlayer androidPlayer) {
        MovingObjectPosition position = MOPhysicsHelper.rayTraceForBlocks((EntityLivingBase)androidPlayer.getPlayer(), androidPlayer.getPlayer().field_70170_p, MAX_TELEPORT_DISTANCE, 0.0f, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), true, true);
        if (position != null && position.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
            Vec3 pos = this.getTopSafeBlock(androidPlayer.getPlayer().field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, position.field_72310_e);
            if (pos != null) {
                return Vec3.func_72443_a((double)(pos.field_72450_a + 0.5), (double)pos.field_72448_b, (double)(pos.field_72449_c + 0.5));
            }
            return null;
        }
        position = MOPhysicsHelper.rayTrace((EntityLivingBase)androidPlayer.getPlayer(), androidPlayer.getPlayer().field_70170_p, 6.0, 0.0f, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), true, true);
        if (position != null) {
            return position.field_72307_f;
        }
        return null;
    }

    public Vec3 getTopSafeBlock(World world, int x, int y, int z, int side) {
        int airBlockCount = 0;
        int heightCheck = MAX_TELEPORT_HEIGHT_CHECK;
        if (side == 1) {
            heightCheck = 3;
        }
        int height = Math.min(y + heightCheck, world.func_72940_L());
        for (int i = y; i < height; ++i) {
            Block block = world.func_147439_a(x, i, z);
            String unlocalizedName = block.func_149739_a().substring(5);
            if (this.blackListedBlocks.contains(unlocalizedName)) {
                return null;
            }
            airBlockCount = !block.func_149747_d((IBlockAccess)world, x, i, z, world.func_72805_g(x, i, z)) || block instanceof IFluidBlock ? ++airBlockCount : 0;
            if (airBlockCount < 2) continue;
            return Vec3.func_72443_a((double)x, (double)(i - 1), (double)z);
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (!world.func_147439_a(x += direction.offsetX, (y += direction.offsetY) + 1, z += direction.offsetZ).func_149747_d((IBlockAccess)world, x, y, z, world.func_72805_g(x, y + 1, z)) && !world.func_147439_a(x, y + 2, z).func_149747_d((IBlockAccess)world, x, y, z, world.func_72805_g(x, y + 2, z))) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (androidPlayer.getPlayer().field_70170_p.field_72995_K && !this.isEnabled(androidPlayer, level)) {
            this.hasPressedKey = false;
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.getEffectLong(EFFECT_KEY_LAST_TELEPORT) <= android.getPlayer().field_70170_p.func_82737_E() && android.extractEnergy(ENERGY_PER_TELEPORT, true) == ENERGY_PER_TELEPORT && android.getActiveStat() != null && android.getActiveStat().equals(this);
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getHasPressedKey() {
        return this.hasPressedKey;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return android.getActiveStat() != null && android.getActiveStat().equals(this);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        String[] blackListedBlocks;
        this.blackListedBlocks.clear();
        for (String block : blackListedBlocks = config.config.getStringList("teleport_blacklist", "abilities", new String[]{"hellsand", "barrier", "bedrock"}, "The Unlocalized names of the blacklist blocks that the player can't teleport to")) {
            this.blackListedBlocks.add(block);
        }
        MAX_TELEPORT_HEIGHT_CHECK = config.getInt("teleport_max_height_check", "abilities", 8, "The max height amount that the teleport ability checks if there is no 2 blocks air space");
        ENERGY_PER_TELEPORT = config.getInt("teleport_energy_cost", "abilities", 4096, "The Energy cost of each Teleportation");
        MAX_TELEPORT_DISTANCE = config.getInt("teleport_max_distance", "abilities", 32, "The maximum distance in blocks, the player can teleport to");
    }
}

