/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatHighJump
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_JUMP = 1024;

    public BioticStatHighJump(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW.toString() + ENERGY_PER_JUMP + " RF" + EnumChatFormatting.GRAY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingEvent.LivingJumpEvent && event.entityLiving.func_70093_af() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, androidPlayer))) {
            if (!event.entity.field_70170_p.field_72995_K) {
                androidPlayer.extractEnergy(ENERGY_PER_JUMP, false);
            }
            event.entityLiving.func_70024_g(0.0, 0.5, 0.0);
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.extractEnergy(ENERGY_PER_JUMP, true) == ENERGY_PER_JUMP;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_JUMP = config.getInt("high_jump_energy", "abilities", 1024, "The energy cost of each High Jump");
    }
}

