/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import matteroverdrive.data.IUseableCondition;
import matteroverdrive.data.inventory.Slot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Inventory
implements IInventory {
    List<Slot> slots;
    String name;
    IUseableCondition useableCondition;

    public Inventory(String name) {
        this(name, new ArrayList<Slot>());
    }

    public Inventory(String name, Collection<Slot> slots) {
        this(name, slots, null);
    }

    public Inventory(String name, Collection<Slot> slots, IUseableCondition useableCondition) {
        this.slots = new ArrayList<Slot>(slots);
        this.name = name;
        this.useableCondition = useableCondition;
    }

    public int AddSlot(Slot slot) {
        if (this.slots.add(slot)) {
            slot.setId(this.slots.size() - 1);
            return this.slots.size() - 1;
        }
        return 0;
    }

    public void setUseableCondition(IUseableCondition condition) {
        this.useableCondition = condition;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (Slot slot : this.slots) {
            slot.setItem(null);
        }
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            this.func_70299_a(b0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            return this.slots.get(slot).getItem();
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.slots.get(slot) != null && this.slots.get(slot).getItem() != null) {
            if (this.slots.get((int)slot).getItem().field_77994_a <= size) {
                ItemStack itemstack = this.slots.get(slot).getItem();
                this.slots.get(slot).setItem(null);
                return itemstack;
            }
            ItemStack itemstack = this.slots.get(slot).getItem().func_77979_a(size);
            if (this.slots.get((int)slot).getItem().field_77994_a == 0) {
                this.slots.get(slot).setItem(null);
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slots.get(slot) != null) {
            ItemStack itemstack = this.slots.get(slot).getItem();
            this.slots.set(slot, null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.slots.get(slot).setItem(item);
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name != "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot >= 0 && slot < this.func_70302_i_() && this.slots.get(slot) != null) {
            return this.slots.get(slot).isValidForSlot(item);
        }
        return true;
    }

    public Slot getSlot(int slotID) {
        return this.slots.get(slotID);
    }

    public int getLastSlotId() {
        return this.slots.size() - 1;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }
}

