/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

public class Bounds {
    int minX;
    int minY;
    int maxX;
    int maxY;

    public Bounds(int minX, int minY, int maxX, int maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void extendMin(int minX, int minY) {
        this.minX = Math.min(minX, this.minX);
        this.minY = Math.min(minY, this.minY);
    }

    public void extendMinBy(int minX, int minY) {
        this.minX += minX;
        this.minY += minY;
    }

    public void extendMax(int maxX, int maxY) {
        this.maxX = Math.max(maxX, this.maxX);
        this.maxY = Math.max(maxY, this.maxY);
    }

    public void extendMaxBy(int maxX, int maxY) {
        this.maxX += maxX;
        this.maxY += maxY;
    }

    public void extend(int minX, int minY, int maxX, int maxY) {
        this.extendMin(minX, minY);
        this.extendMax(maxX, maxY);
    }

    public void extend(Bounds bounds) {
        this.extendMin(bounds.minX, bounds.minY);
        this.extendMax(bounds.maxX, bounds.maxY);
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }
}

