/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cofh.lib.gui.GuiColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.Reference;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererAbstract;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class StarMapRendererStars
extends StarMapRendererAbstract {
    protected void renderStars(Quadrant quadrant, TileEntityMachineStarMap starMap, double distanceMultiply, double starSizeMultiply) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        Vec3 pos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        if (quadrant != null) {
            GL11.glLineWidth((float)1.0f);
            Tessellator.field_78398_a.func_78382_b();
            Star from = null;
            Star to = null;
            this.bindTexture(ClientProxy.renderHandler.getRenderParticlesHandler().getAdditiveTextureSheet());
            for (Star star : quadrant.getStars()) {
                pos.field_72450_a = star.getPosition().field_72450_a * distanceMultiply;
                pos.field_72448_b = star.getPosition().field_72448_b * distanceMultiply;
                pos.field_72449_c = star.getPosition().field_72449_c * distanceMultiply;
                this.drawStarParticle(quadrant, star, pos, (EntityPlayer)player, starMap, starSizeMultiply);
                if (starMap.getGalaxyPosition().equals(star)) {
                    from = star;
                }
                if (!starMap.getDestination().equals(star)) continue;
                to = star;
            }
            if (from != null && to != null && from != to) {
                this.drawConnection(from, to, distanceMultiply);
            }
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    protected void drawConnection(Star from, Star to, double distanceMultiply) {
        GL11.glDisable((int)3553);
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.3f);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)((double)from.getX() * distanceMultiply), (double)((double)from.getY() * distanceMultiply), (double)((double)from.getZ() * distanceMultiply));
        GL11.glVertex3d((double)((double)to.getX() * distanceMultiply), (double)((double)to.getY() * distanceMultiply), (double)((double)to.getZ() * distanceMultiply));
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    protected void drawStarParticle(Quadrant quadrant, Star star, Vec3 pos, EntityPlayer player, TileEntityMachineStarMap starMap, double starSizeMultiply) {
        GuiColor color = StarMapRendererStars.getStarColor(star, player);
        double size = 0.01;
        if (starMap.getDestination().equals(star)) {
            size = 0.035;
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.selectedIcon, (double)star.getSize() * 0.05 * starSizeMultiply, pos, color);
        }
        if (starMap.getGalaxyPosition().equals(star)) {
            size = 0.035;
            RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.currentIcon, (double)star.getSize() * 0.05 * starSizeMultiply, pos, color);
        }
        if (star.isClaimed(player) == 3) {
            size = 0.025;
        }
        RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, this.star_icon, (double)star.getSize() * size * starSizeMultiply, pos, color);
    }

    private void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }

    public static GuiColor getStarColor(Star star, EntityPlayer player) {
        return new GuiColor(star.getColor());
    }
}

