/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import cofh.lib.gui.GuiColor;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.weapon.PhaserRifle;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ItemRendererPhaserRifle
implements IItemRenderer {
    public static final String TEXTURE = "mo:textures/items/phaser_rifle.png";
    public static final String MODEL = "mo:models/item/phaser_rifle.obj";
    public static final String FLASH_TEXTURE = "mo:textures/fx/phaser_rifle_flash.png";
    public static final float SCALE = 1.0f;
    public static final float THIRD_PERSON_SCALE = 0.8f;
    public static final float ITEM_SCALE = 0.4f;
    public static final float SCALE_DROP = 0.5f;
    public static float RECOIL_TIME = 0.0f;
    public static float RECOIL_AMOUNT = 0.0f;
    private static float ZOOM_TIME = 0.0f;
    public static IModelCustom phaserModel;
    public static ResourceLocation phaserTexture;
    public static ResourceLocation flashTexture;

    public ItemRendererPhaserRifle() {
        phaserTexture = new ResourceLocation(TEXTURE);
        phaserModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(MODEL));
        flashTexture = new ResourceLocation(FLASH_TEXTURE);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.RenderFirstPerson(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.RenderItem(item);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.RenderDrop(item);
        } else {
            this.RenderThirdPerson(type, item);
        }
    }

    void RenderItem(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.4f, (double)0.4f, (double)0.4f);
        GL11.glTranslated((double)0.0, (double)0.03, (double)-0.7);
        GL11.glRotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        this.RenderGun(IItemRenderer.ItemRenderType.INVENTORY, item);
        GL11.glPopMatrix();
    }

    void RenderThirdPerson(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.8f, (double)0.8f, (double)0.8f);
        GL11.glTranslated((double)1.0, (double)0.83, (double)1.0);
        GL11.glRotated((double)-135.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)60.0, (double)1.0, (double)0.0, (double)0.0);
        this.RenderGun(renderType, item);
        GL11.glPopMatrix();
    }

    void RenderDrop(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.7);
        this.RenderGun(IItemRenderer.ItemRenderType.ENTITY, item);
        GL11.glPopMatrix();
    }

    void RenderFirstPerson(ItemStack item) {
        ZOOM_TIME = MOMathHelper.Lerp(ZOOM_TIME, Minecraft.func_71410_x().field_71439_g.func_71039_bw() ? 1.0f : 0.0f, 0.2f);
        RECOIL_TIME = MOMathHelper.Lerp(RECOIL_TIME, 0.0f, 0.1f);
        float zoomValue = MOEasing.Quart.easeOut(ZOOM_TIME, 0.0f, 1.0f, 1.0f);
        float recoilValue = MOEasing.Quad.easeInOut(RECOIL_TIME, 0.0f, 1.0f, 1.0f);
        GL11.glPushMatrix();
        ResourceLocation skin = Minecraft.func_71410_x().field_71439_g.func_110306_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(skin);
        GL11.glTranslated((double)2.0, (double)MOMathHelper.Lerp(-0.4f, MOMathHelper.Lerp(-0.3f, -0.4f, zoomValue), recoilValue), (double)MOMathHelper.Lerp(-1.0f, -1.1f, zoomValue));
        GL11.glRotated((double)MOMathHelper.Lerp(45.0f, 0.0f, zoomValue), (double)1.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)MOMathHelper.Lerp(0.0f, MOMathHelper.Lerp(3.0f, 0.0f, zoomValue), recoilValue), (double)0.0, (double)0.0, (double)1.0);
        double length = 1.8;
        double width = 0.6;
        double depth = 0.5;
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
        Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
        Tessellator.field_78398_a.func_78374_a(depth, length, 0.0, 0.75, 1.0);
        Tessellator.field_78398_a.func_78374_a(depth, 0.0, 0.0, 0.75, 0.625);
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, width, 0.625, 0.625);
        Tessellator.field_78398_a.func_78374_a(0.0, length, width, 0.625, 1.0);
        Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glRotated((double)MOMathHelper.Lerp(30.0f, 25.0f, zoomValue), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)MOMathHelper.Lerp(90.0f, 85.0f, zoomValue), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)MOMathHelper.Lerp(0.0f, 0.86f, zoomValue), (double)MOMathHelper.Lerp(-0.4f, -0.05f, zoomValue), (double)MOMathHelper.Lerp(1.2f, 0.6f, zoomValue));
        GL11.glScaled((double)1.0, (double)1.0, (double)0.6);
        GL11.glTranslatef((float)0.0f, (float)(-recoilValue * 0.03f * RECOIL_AMOUNT), (float)(-recoilValue * 0.05f * RECOIL_AMOUNT));
        GL11.glRotated((double)(recoilValue * 2.0f * RECOIL_AMOUNT), (double)-1.0, (double)0.0, (double)0.0);
        this.RenderGun(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, item);
        GL11.glPopMatrix();
        this.renderMuzzle(item, recoilValue, zoomValue);
    }

    private void renderMuzzle(ItemStack item, float recoilValue, float zoomValue) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        RenderUtils.disableLightmap();
        double size = 1.0f + 1.0f * MatterOverdriveItems.phaserRifle.getHeat(item) / MatterOverdriveItems.phaserRifle.getMaxHeat(item);
        GL11.glTranslated((double)3.0, (double)1.9, (double)MOMathHelper.Lerp(-0.1f, -0.7f, zoomValue));
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)15.0, (double)-1.0, (double)0.0, (double)0.0);
        float scale = MOEasing.Quart.easeIn(recoilValue, 0.0f, 1.0f, 1.0f);
        GuiColor color = WeaponHelper.getColor(item);
        RenderUtils.applyColorWithMultipy(color, scale);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(flashTexture);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(-size, -size, 0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(-size, size, 0.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(size, size, 0.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(size, -size, 0.0, 1.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    void RenderGun(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        IWeaponModule module;
        Object colorObject;
        GuiColor color = WeaponHelper.getColor(item);
        ItemStack color_module = WeaponHelper.getModuleAtSlot(1, item);
        if (color_module != null && (colorObject = (module = (IWeaponModule)color_module.func_77973_b()).getValue(color_module)) instanceof GuiColor) {
            color = (GuiColor)colorObject;
        }
        GL11.glColor4f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)color.getFloatA());
        Minecraft.func_71410_x().field_71446_o.func_110577_a(phaserTexture);
        phaserModel.renderAll();
    }

    public boolean isRifleZoomed(ItemStack itemStack) {
        return Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71439_g.func_70694_bm() != null && Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77973_b() instanceof PhaserRifle && Mouse.isButtonDown((int)1);
    }
}

