/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import cofh.lib.gui.GuiColor;
import cofh.lib.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.client.render.item.ItemRendererPhaser;
import matteroverdrive.client.sound.PhaserSound;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.weapon.Phaser;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.util.MOPhysicsHelper;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RendererPhaserBeam
implements IWorldLastRenderer {
    Map<Entity, PhaserSound> soundMap = new HashMap<Entity, PhaserSound>();
    public static ResourceLocation phaserSoundLocation = new ResourceLocation("mo:phaser_beam_1");

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-Minecraft.func_71410_x().field_71439_g.field_70165_t), (double)(-Minecraft.func_71410_x().field_71439_g.field_70163_u), (double)(-Minecraft.func_71410_x().field_71439_g.field_70161_v));
        this.renderClient(renderHandler);
        this.renderOthers(renderHandler);
        GL11.glPopMatrix();
    }

    public void renderOthers(RenderHandler renderHandler) {
        for (Object playerObj : Minecraft.func_71410_x().field_71441_e.func_72910_y()) {
            if (!(playerObj instanceof EntityOtherPlayerMP)) continue;
            EntityOtherPlayerMP playerMP = (EntityOtherPlayerMP)playerObj;
            if (playerMP.func_71039_bw() && playerMP.func_71011_bu().func_77973_b() instanceof Phaser) {
                this.renderBeam(playerMP.func_71011_bu(), (EntityPlayer)playerMP, playerMP.field_70170_p, new Vector3f(-0.23f, 0.2f, 0.7f), playerMP.func_70047_e() - 0.5f, -0.3f);
                this.PlayPhaserSound((Entity)playerMP, renderHandler.getRandom());
                continue;
            }
            this.StopPhaserSound((Entity)playerMP);
        }
    }

    public void renderClient(RenderHandler renderHandler) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_71039_bw() && player.func_71011_bu().func_77973_b() instanceof Phaser) {
            this.renderBeam(player.func_71011_bu(), (EntityPlayer)player, player.field_70170_p, new Vector3f(-0.1f, -0.1f, 0.15f), 0.0f, 0.25f);
            this.PlayPhaserSound((Entity)player, renderHandler.getRandom());
        } else {
            this.StopPhaserSound((Entity)player);
        }
    }

    public void renderBeam(ItemStack phaser, EntityPlayer viewer, World world, Vector3f offset, float height, float distanceOffset) {
        RenderHelper.bindTexture((ResourceLocation)ItemRendererPhaser.phaserTexture);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GuiColor color = this.getPhaserColor(viewer);
        GL11.glColor4f((float)color.getFloatR(), (float)color.getFloatG(), (float)color.getFloatB(), (float)color.getFloatA());
        GL11.glPushMatrix();
        GL11.glTranslated((double)viewer.field_70165_t, (double)(viewer.field_70163_u + (double)height), (double)viewer.field_70161_v);
        GL11.glRotated((double)(-viewer.func_70079_am()), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)viewer.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslatef((float)offset.x, (float)offset.y, (float)offset.z);
        MovingObjectPosition hit = MOPhysicsHelper.rayTrace((EntityLivingBase)viewer, world, this.getPhaserRange(viewer), 0.0f, Vec3.func_72443_a((double)0.0, (double)height, (double)0.0), false, true, MatterOverdriveItems.phaser.getPlayerLook(viewer, phaser));
        double distance = 450.0;
        if (hit != null) {
            Vec3 hitVector = hit.field_72307_f;
            distance = hitVector.func_72438_d(viewer.func_70666_h(1.0f));
            MatterOverdriveItems.phaser.spawnParticle(hit, phaser, world);
        }
        Vec3 rots = MatterOverdriveItems.phaser.getBeamRotation(phaser, world);
        GL11.glRotated((double)Math.toDegrees(rots.field_72450_a), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)Math.toDegrees(rots.field_72448_b), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)Math.toDegrees(rots.field_72449_c), (double)0.0, (double)0.0, (double)1.0);
        GL11.glScaled((double)1.0, (double)1.0, (double)(distance + (double)distanceOffset));
        ItemRendererPhaser.phaserModel.renderPart("beam");
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public GuiColor getPhaserColor(EntityPlayer player) {
        IWeaponModule module;
        Object colorObject;
        GuiColor color = WeaponModuleColor.defaultColor;
        ItemStack color_module = WeaponHelper.getModuleAtSlot(1, player.func_71011_bu());
        if (color_module != null && (colorObject = (module = (IWeaponModule)color_module.func_77973_b()).getValue(color_module)) instanceof GuiColor) {
            color = (GuiColor)colorObject;
        }
        return color;
    }

    private int getPhaserRange(EntityPlayer player) {
        int range = 24;
        ItemStack phaserStack = player.func_71011_bu();
        if (phaserStack != null && phaserStack.func_77973_b() instanceof Phaser) {
            range = ((Phaser)phaserStack.func_77973_b()).getRange(phaserStack);
        }
        return range;
    }

    private void PlayPhaserSound(Entity entity, Random random) {
        if (!this.soundMap.containsKey(entity)) {
            PhaserSound sound = new PhaserSound(phaserSoundLocation, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, random.nextFloat() * 0.05f + 0.2f, 1.0f);
            this.soundMap.put(entity, sound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        } else if (this.soundMap.get(entity).func_147667_k()) {
            this.StopPhaserSound(entity);
            this.PlayPhaserSound(entity, random);
        } else {
            this.soundMap.get(entity).setPosition((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v);
        }
    }

    private void StopPhaserSound(Entity entity) {
        if (this.soundMap.containsKey(entity)) {
            PhaserSound sound = this.soundMap.get(entity);
            sound.stopPlaying();
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            this.soundMap.remove(entity);
        }
    }
}

