/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks.includes;

import cofh.api.block.IDismantleable;
import cofh.lib.util.helpers.InventoryHelper;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.items.includes.MOEnergyMatterBlockItem;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.tile.IMOTileEntity;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class MOBlockMachine
extends MOBlockContainer
implements IDismantleable,
IConfigSubscriber {
    public float volume = 1.0f;
    public boolean hasGui;

    public MOBlockMachine(Material material, String name) {
        super(material, name);
    }

    @Override
    protected void registerBlock() {
        GameRegistry.registerBlock((Block)this, MOEnergyMatterBlockItem.class, (String)this.func_149739_a().substring(5));
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        IMOTileEntity entity = (IMOTileEntity)world.func_147438_o(x, y, z);
        if (entity != null) {
            try {
                entity.readFromPlaceItem(itemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
                FMLLog.log((Level)Level.ERROR, (String)"Could not load settings from placing item", (Object[])new Object[]{e});
            }
            entity.onPlaced(world, entityLiving);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        MOTileEntityMachine machine;
        super.func_149749_a(world, x, y, z, block, meta);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof MOTileEntityMachine && (machine = (MOTileEntityMachine)world.func_147438_o(x, y, z)) != null) {
            MatterHelper.DropInventory(world, (IInventory)((MOTileEntityMachine)world.func_147438_o(x, y, z)), x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && this.hasGui && (tileEntity = world.func_147438_o(x, y, z)) instanceof MOTileEntityMachine) {
            if (((MOTileEntityMachine)tileEntity).func_70300_a(player)) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MatterOverdrive.instance, (int)-1, (World)world, (int)x, (int)y, (int)z);
                return true;
            }
            ChatComponentText message = new ChatComponentText(EnumChatFormatting.GOLD + "[Matter Overdrive] " + EnumChatFormatting.RED + MOStringHelper.translateToLocal(this.getUnlocalizedMessage(0)).replace("$0", this.func_149732_F()));
            message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            player.func_145747_a((IChatComponent)message);
        }
        return false;
    }

    protected String getUnlocalizedMessage(int type) {
        switch (type) {
            case 0: {
                return "alert.no_rights";
            }
        }
        return "alert.no_access_default";
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof MOTileEntityMachine && !player.field_71075_bZ.field_75098_d && ((MOTileEntityMachine)tileEntity).hasOwner() && !((MOTileEntityMachine)tileEntity).getOwner().equals(player.func_146103_bH().getId())) {
            ChatComponentText message = new ChatComponentText(EnumChatFormatting.GOLD + "[Matter Overdrive] " + EnumChatFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights.brake").replace("$0", this.func_149732_F()));
            message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
            player.func_145747_a((IChatComponent)message);
            return false;
        }
        return world.func_147468_f(x, y, z);
    }

    public ItemStack getNBTDrop(World world, int x, int y, int z, IMOTileEntity te) {
        int meta = this.func_149692_a(world.func_72805_g(x, y, z));
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        if (te != null) {
            te.writeToDropItem(itemStack);
        }
        return itemStack;
    }

    public boolean hasGui() {
        return this.hasGui;
    }

    public void setHasGui(boolean hasGui) {
        this.hasGui = hasGui;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack blockItem = this.getNBTDrop(world, x, y, z, (IMOTileEntity)world.func_147438_o(x, y, z));
        MOTileEntityMachine machine = (MOTileEntityMachine)world.func_147438_o(x, y, z);
        items.add(blockItem);
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        boolean flag = block.removedByPlayer(world, player, x, y, z, true);
        super.func_149749_a(world, x, y, z, block, l);
        if (flag) {
            block.func_149664_b(world, x, y, z, l);
        }
        if (!returnDrops) {
            for (int i1 = 0; i1 < machine.getInventoryContainer().func_70302_i_(); ++i1) {
                Slot slot = machine.getInventoryContainer().getSlot(i1);
                ItemStack itemstack = slot.getItem();
                if (itemstack == null || slot.keepOnDismatle()) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            this.func_149642_a(world, x, y, z, blockItem);
        } else {
            InventoryHelper.insertItemStackIntoInventory((IInventory)player.field_71071_by, (ItemStack)blockItem, (int)0);
        }
        return items;
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MOTileEntityMachine) {
            if (player.field_71075_bZ.field_75098_d || !((MOTileEntityMachine)tileEntity).hasOwner()) {
                return true;
            }
            if (((MOTileEntityMachine)tileEntity).getOwner().equals(player.func_146103_bH().getId())) {
                return true;
            }
            if (world.field_72995_K) {
                ChatComponentText message = new ChatComponentText(EnumChatFormatting.GOLD + "[Matter Overdrive] " + EnumChatFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights.dismantle").replace("$0", this.func_149732_F()));
                message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
                player.func_145747_a((IChatComponent)message);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        config.initMachineCategory(this.func_149739_a());
        this.volume = (float)config.getMachineDouble(this.func_149739_a(), "volume", 1.0, "The volume of the Machine");
    }
}

