/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import cofh.lib.util.helpers.BlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.blocks.includes.MOMatterEnergyStorageBlock;
import matteroverdrive.client.render.block.MOBlockRenderer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.tile.TileEntityMachineDecomposer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDecomposer
extends MOMatterEnergyStorageBlock {
    public IIcon iconTop;

    public BlockDecomposer(Material material, String name) {
        super(material, name, true, true);
        this.func_149711_c(20.0f);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("mo:decomposer_top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (side == metadata) {
            return this.GetIconBasedOnMatter(world, x, y, z);
        }
        return this.func_149691_a(side, metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == BlockHelper.getAboveSide((int)metadata)) {
            return this.iconTop;
        }
        if (side == metadata) {
            return MatterOverdriveIcons.Matter_tank_empty;
        }
        return MatterOverdriveIcons.YellowStripes;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMachineDecomposer();
    }

    public int func_149645_b() {
        return MOBlockRenderer.renderID;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        config.initMachineCategory(this.func_149739_a());
        TileEntityMachineDecomposer.MATTER_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.matter", 1024, String.format("How much matter can the %s hold", this.func_149732_F()));
        TileEntityMachineDecomposer.ENERGY_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.energy", 512000, String.format("How much energy can the %s hold", this.func_149732_F()));
        TileEntityMachineDecomposer.DECEOPOSE_SPEED_PER_MATTER = config.getMachineInt(this.func_149739_a(), "speed.decompose", 80, "The speed in ticks, of decomposing. (per matter)");
        TileEntityMachineDecomposer.DECOMPOSE_ENERGY_PER_MATTER = config.getMachineInt(this.func_149739_a(), "cost.decompose", 8000, "Decomposing cost per matter");
    }
}

