/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.client.render.block.RendererBlockChargingStation;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.tile.TileEntityMachineChargingStation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChargingStation
extends MOBlockMachine {
    public BlockChargingStation(Material material, String name) {
        super(material, name);
        this.func_149711_c(20.0f);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.field_149784_t = 10;
        this.setHasGui(true);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && world.func_147439_a(x, y + 1, z).isReplaceable((IBlockAccess)world, x, y + 1, z) && world.func_147439_a(x, y + 2, z).isReplaceable((IBlockAccess)world, x, y + 2, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        world.func_147449_b(x, y + 1, z, (Block)MatterOverdriveBlocks.boundingBox);
        world.func_147449_b(x, y + 2, z, (Block)MatterOverdriveBlocks.boundingBox);
        return meta;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityMachineChargingStation) {
            TileEntityMachineChargingStation chargingStation = (TileEntityMachineChargingStation)te;
            chargingStation.getBoundingBlocks().forEach(coord -> world.func_147468_f(coord.x, coord.y, coord.z));
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return MatterOverdriveIcons.Base;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMachineChargingStation();
    }

    public int func_149645_b() {
        return RendererBlockChargingStation.renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        TileEntityMachineChargingStation.RANGE = config.getInt("charge station range", "machine options", 16, "The range of the Charge Station");
    }
}

