/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.recipe.ICookingHeatSource;
import mods.defeatedcrow.api.recipe.IPanRecipe;
import mods.defeatedcrow.api.recipe.IPanRecipeRegister;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PanRecipeRegister
implements IPanRecipeRegister {
    private static List<PanRecipe> recipes;
    @Deprecated
    private static List<ItemStack> heatSource;
    private static List<PanHeatSource> sources;

    public PanRecipeRegister() {
        recipes = new ArrayList<PanRecipe>();
        heatSource = new ArrayList<ItemStack>();
        sources = new ArrayList<PanHeatSource>();
    }

    public List<PanRecipe> getRecipeList() {
        return recipes;
    }

    @Override
    public List<ItemStack> getHeatSourceList() {
        return heatSource;
    }

    public List<PanHeatSource> getHeatSourcesList() {
        return sources;
    }

    public IPanRecipeRegister instance() {
        return RecipeRegisterManager.panRecipe;
    }

    @Override
    public PanRecipe getRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (PanRecipe recipe : recipes) {
            if (!this.isItemEqual(item, recipe.getInput().func_77973_b(), recipe.getInput().func_77960_j())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean isHeatSource(Block block, int meta) {
        if (block == null) {
            return false;
        }
        for (PanHeatSource source : sources) {
            if (block != source.block || source.metadata != -1 && source.metadata != meta) continue;
            return true;
        }
        return false;
    }

    private boolean isItemEqual(ItemStack a, Item b, int meta) {
        if (a == null) {
            return false;
        }
        boolean flag = false;
        if (a.func_77973_b() == b) {
            if (a.func_77960_j() == meta) {
                flag = true;
            } else if (a.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void register(ItemStack input, ItemStack output, String tex, String disp) {
        if (input != null) {
            this.register(input, output, output, tex, disp);
        }
    }

    @Override
    public void register(ItemStack input, ItemStack output, ItemStack output2, String tex, String disp) {
        if (input != null) {
            recipes.add(new PanRecipe(input, output, output2, tex, disp));
        }
        AMTLogger.debugInfo("Add Pan Recipe: input " + input.func_82833_r() + ", output " + output.func_82833_r());
    }

    @Override
    public void registerHeatSource(Block block, int meta) {
        if (block != null) {
            sources.add(new PanHeatSource(block, meta));
            AMTLogger.debugInfo("Add pan heat source : " + block.func_149732_F() + ":" + meta);
        }
    }

    public class PanHeatSource
    implements ICookingHeatSource {
        private final Block block;
        private final int metadata;

        public PanHeatSource(Block b, int m) {
            this.block = b;
            this.metadata = m;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }

        @Override
        public int getMetadata() {
            return this.metadata;
        }
    }

    public class PanRecipe
    implements IPanRecipe {
        private final ItemStack input;
        private final ItemStack output;
        private final ItemStack outputJP;
        private final String Tex;
        private final String display;

        public PanRecipe(ItemStack inputItem, ItemStack outputItem, ItemStack jpItem, String tex, String disp) {
            this.input = inputItem;
            this.output = outputItem;
            this.outputJP = jpItem;
            this.Tex = tex;
            this.display = disp;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.func_77946_l();
        }

        @Override
        public ItemStack getOutputJP() {
            if (this.outputJP == null) {
                return null;
            }
            return this.outputJP.func_77946_l();
        }

        @Override
        public String getTex() {
            if (this.Tex == null) {
                return "rice";
            }
            return this.Tex;
        }

        @Override
        public String getDisplayName() {
            if (this.display == null) {
                return "Rice";
            }
            return this.display;
        }
    }
}

