/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.recipe;

import java.util.ArrayList;
import java.util.List;
import mods.defeatedcrow.api.charge.ChargeItemManager;
import mods.defeatedcrow.api.charge.IChargeItem;
import mods.defeatedcrow.api.charge.IChargeItemRegister;
import mods.defeatedcrow.common.AMTLogger;
import net.minecraft.item.ItemStack;

public class ChargeItemRegister
implements IChargeItemRegister {
    private static List<ChargeItem> chargeItems;

    public ChargeItemRegister() {
        chargeItems = new ArrayList<ChargeItem>();
    }

    public IChargeItemRegister instance() {
        return ChargeItemManager.chargeItem;
    }

    @Override
    public List<? extends IChargeItem> getChargeItemList() {
        return chargeItems;
    }

    @Override
    public int getChargeAmount(ItemStack item) {
        if (item == null) {
            return 0;
        }
        for (ChargeItem chargeable : chargeItems) {
            if (!this.isItemEqual(item, chargeable.getItem())) continue;
            return chargeable.chargeAmount();
        }
        return 0;
    }

    private boolean isItemEqual(ItemStack a, ItemStack b) {
        boolean flag = false;
        if (a.func_77973_b() == b.func_77973_b()) {
            if (a.func_77960_j() == b.func_77960_j()) {
                flag = true;
            } else if (a.func_77960_j() == Short.MAX_VALUE) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void registerCharger(ItemStack input, ItemStack output, int val) {
        if (input != null) {
            if (input.func_77984_f()) {
                chargeItems.add(new ChargeItem(input, output, 0));
                AMTLogger.debugInfo("Add damageable chargeable item: input " + input.func_82833_r());
            } else if (val > 0) {
                chargeItems.add(new ChargeItem(input, output, val));
                AMTLogger.debugInfo("Add damageable chargeable item: input " + input.func_82833_r() + " val : " + val);
            }
        }
    }

    public class ChargeItem
    implements IChargeItem {
        private final ItemStack input;
        private final ItemStack output;
        private final int amount;

        public ChargeItem(ItemStack item, ItemStack output, int val) {
            this.input = item;
            this.amount = val;
            this.output = output;
        }

        @Override
        public int chargeAmount() {
            return this.amount;
        }

        @Override
        public ItemStack getItem() {
            if (this.input == null) {
                return null;
            }
            return this.input;
        }

        @Override
        public ItemStack returnItem() {
            if (this.output == null) {
                return null;
            }
            return this.output;
        }
    }
}

