/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.plugin.IC2;

import cpw.mods.fml.common.Loader;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import ic2.core.block.TileEntityBarrel;
import mods.defeatedcrow.api.recipe.RecipeRegisterManager;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.plugin.LoadModHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;

public class LoadIC2Plugin {
    public static ItemStack IC2Cell;
    public static ItemStack IC2WaterCell;
    public static ItemStack IC2Coffeepowder;
    public static ItemStack IC2Mug;
    public static ItemStack IC2MugCoffee;
    public static ItemStack IC2MugCoffeeMilk;
    public static ItemStack IC2dropRubber;
    public static Item IC2Rum;
    public static ItemStack IC2Furnace;

    public void load() {
        IC2Cell = new ItemStack(IC2Items.getItem((String)"cell").func_77973_b(), 1, IC2Items.getItem((String)"cell").func_77960_j());
        IC2WaterCell = new ItemStack(IC2Items.getItem((String)"waterCell").func_77973_b(), 1, IC2Items.getItem((String)"waterCell").func_77960_j());
        IC2Coffeepowder = new ItemStack(IC2Items.getItem((String)"coffeePowder").func_77973_b(), 1, IC2Items.getItem((String)"coffeePowder").func_77960_j());
        IC2Mug = new ItemStack(IC2Items.getItem((String)"mugEmpty").func_77973_b(), 1, 0);
        IC2MugCoffee = new ItemStack(IC2Items.getItem((String)"mugCoffee").func_77973_b(), 1, 1);
        IC2MugCoffeeMilk = new ItemStack(IC2Items.getItem((String)"mugCoffee").func_77973_b(), 1, 2);
        IC2dropRubber = new ItemStack(IC2Items.getItem((String)"rubber").func_77973_b(), 1, IC2Items.getItem((String)"rubber").func_77960_j());
        IC2Furnace = new ItemStack(IC2Items.getItem((String)"ironFurnace").func_77973_b(), 1, IC2Items.getItem((String)"ironFurnace").func_77960_j());
        if (IC2Coffeepowder != null) {
            RecipeRegisterManager.teaRecipe.registerCanMilk(IC2Coffeepowder, new ItemStack(DCsAppleMilk.teacupBlock, 1, 12), new ItemStack(DCsAppleMilk.teacupBlock, 1, 13), new String("defeatedcrow:textures/blocks/contents_cocoa.png"), new String("defeatedcrow:textures/blocks/contents_cocoa_milk.png"));
        }
        if (IC2WaterCell != null && LoadModHandler.registerModItems("containerWater", IC2WaterCell)) {
            AMTLogger.debugInfo("Succeeded to get IC2 water cell");
        }
        if (IC2Furnace != null) {
            if (LoadModHandler.registerModItems("furnaceBlock", IC2Furnace)) {
                RecipeRegisterManager.panRecipe.registerHeatSource(Block.func_149634_a((Item)IC2Furnace.func_77973_b()), 1);
                AMTLogger.debugInfo("Succeeded to get IC2 Iron Furnace");
            }
        }
        try {
            if (FluidRegistry.isFluidRegistered((String)"vegitable_oil")) {
                Recipes.semiFluidGenerator.addFluid("vegitable_oil", 1, 1.0);
                AMTLogger.debugInfo("Succeeded to register fuel for IC2 Semifluid Generator : vegitable_oil");
            }
            if (FluidRegistry.isFluidRegistered((String)"camellia_oil")) {
                Recipes.semiFluidGenerator.addFluid("camellia_oil", 1, 1.2);
                AMTLogger.debugInfo("Succeeded to register fuel for IC2 Semifluid Generator : camellia_oil");
            }
        }
        catch (Exception e) {
            AMTLogger.debugInfo("Failed to register IC2machines recipe");
            e.printStackTrace(System.err);
        }
    }

    public static void loadRecipes(boolean flag) {
        if (!flag) {
            return;
        }
        try {
            RecipeInputItemStack input = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.woodBox, 1, 4), 1);
            NBTTagCompound metadata = new NBTTagCompound();
            metadata.func_74768_a("extractor", 2000);
            ItemStack outputs = new ItemStack(IC2dropRubber.func_77973_b(), 9, 0);
            Recipes.extractor.addRecipe((IRecipeInput)input, metadata, new ItemStack[]{outputs});
            RecipeInputItemStack input2 = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.leafTea, 1, 0), 1);
            NBTTagCompound metadata2 = new NBTTagCompound();
            metadata2.func_74768_a("macerater", 2000);
            ItemStack outputs2 = new ItemStack(DCsAppleMilk.foodTea, 2, 0);
            RecipeInputItemStack input3 = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.emptyBottle, 1, 0), 1);
            ItemStack outputs3 = new ItemStack(DCsAppleMilk.EXItems, 2, 5);
            RecipeInputItemStack input4 = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.clam, 1, 0), 1);
            ItemStack outputs4 = new ItemStack(DCsAppleMilk.EXItems, 2, 6);
            RecipeInputItemStack input5 = new RecipeInputItemStack(new ItemStack(Items.field_151044_h, 1, 1), 1);
            ItemStack outputs5 = new ItemStack(DCsAppleMilk.dustWood, 1, 1);
            Recipes.macerator.addRecipe((IRecipeInput)input2, metadata2, new ItemStack[]{outputs2});
            Recipes.macerator.addRecipe((IRecipeInput)input3, metadata2, new ItemStack[]{outputs3});
            Recipes.macerator.addRecipe((IRecipeInput)input4, metadata2, new ItemStack[]{outputs4});
            if (!Loader.isModLoaded((String)"Railcraft")) {
                Recipes.macerator.addRecipe((IRecipeInput)input5, metadata2, new ItemStack[]{outputs5});
            }
            AMTLogger.debugInfo("Succeeded to register IC2machines recipe");
            RecipeInputItemStack input6 = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.leafTea, 1, 3), 2);
            NBTTagCompound metadata3 = new NBTTagCompound();
            metadata2.func_74768_a("macerater", 2000);
            ItemStack outputs6 = new ItemStack(DCsAppleMilk.yuzuGel, 1, 0);
            RecipeInputItemStack input7 = new RecipeInputItemStack(new ItemStack(Blocks.field_150440_ba, 1, 0), 9);
            ItemStack outputs7 = new ItemStack(DCsAppleMilk.silkyMelon, 1, 0);
            RecipeInputItemStack input8 = new RecipeInputItemStack(new ItemStack(DCsAppleMilk.flintBlock, 1, 0), 4);
            ItemStack outputs8 = new ItemStack(DCsAppleMilk.chalcedony, 1, 0);
            Recipes.compressor.addRecipe((IRecipeInput)input6, metadata3, new ItemStack[]{outputs6});
            Recipes.compressor.addRecipe((IRecipeInput)input7, metadata3, new ItemStack[]{outputs7});
            Recipes.compressor.addRecipe((IRecipeInput)input8, metadata3, new ItemStack[]{outputs8});
        }
        catch (Exception e) {
            AMTLogger.debugInfo("Failed to register IC2machines recipe");
            e.printStackTrace(System.err);
        }
    }

    public static boolean isRumBarrel(TileEntity tile, boolean simulate) {
        if (tile instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)tile;
            if (barrel.isEmpty()) {
                return false;
            }
            boolean flag = false;
            int type = barrel.type;
            int age = barrel.age;
            int boose = barrel.boozeAmount;
            int progress = age * 100 / barrel.timeNedForRum(boose);
            if (progress > 80) {
                flag = true;
                if (!simulate) {
                    barrel.drainLiquid(boose);
                }
            }
            AMTLogger.debugInfo("IC2 barrel :" + flag + " age:" + age + " progress:" + progress);
            return flag;
        }
        return false;
    }
}

