/*
 * Decompiled with CFR 0.152.
 */
package mods.defeatedcrow.handler;

import cpw.mods.fml.common.registry.GameRegistry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import mods.defeatedcrow.common.AMTLogger;
import mods.defeatedcrow.common.DCsAppleMilk;
import mods.defeatedcrow.common.config.DCsConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Util {
    public static final int[] METAX = new int[]{0, -1, 0, 1};
    public static final int[] METAZ = new int[]{-1, 0, 1, 0};
    public static final int[] RAD = new int[]{0, -90, 180, 90};

    private Util() {
    }

    public static int getCupRender() {
        int l = DCsConfig.setCupTexture;
        if (l < 0) {
            l = 1;
        } else if (l > 3) {
            l = 3;
        }
        return l;
    }

    public static int getTeppannReadyTime() {
        int l = DCsConfig.teppannReadyTime;
        if (l < 0) {
            l = 1;
        } else if (l > 60) {
            l = 60;
        }
        return l;
    }

    public static int getCupStacksize() {
        int l = DCsConfig.cupStackSize;
        l = l <= 1 ? 1 : (l <= 3 ? 3 : 8);
        return l;
    }

    public static int getHamaguriChanceValue() {
        int l = DCsConfig.clamChanceValue;
        if (l < 0) {
            l = 1;
        } else if (l > 100) {
            l = 100;
        }
        return l;
    }

    public static String getTexturePass() {
        int l = DCsConfig.setAltTexturePass - 1;
        if (l < 0) {
            l = 0;
        } else if (l > 2) {
            l = 2;
        }
        return DCsAppleMilk.TEX_PASS[l];
    }

    public static String getTexturePassNoAlt() {
        int l = DCsConfig.setAltTexturePass - 1;
        if (l < 0) {
            l = 0;
        } else if (l > 1) {
            l = 1;
        }
        return DCsAppleMilk.TEX_PASS[l];
    }

    public static String getEntityTexturePass() {
        int l = DCsConfig.setAltTexturePass - 1;
        if (l < 0) {
            l = 0;
        } else if (l > 2) {
            l = 2;
        }
        return DCsAppleMilk.TEX_PASS_ENTITY[l];
    }

    public static String getEntityTexturePassNoAlt() {
        int l = DCsConfig.setAltTexturePass - 1;
        if (l < 0) {
            l = 0;
        } else if (l > 1) {
            l = 1;
        }
        return DCsAppleMilk.TEX_PASS_ENTITY[l];
    }

    public static String getEntityTexturePassAlt() {
        return DCsAppleMilk.TEX_PASS_ALT[0];
    }

    public static float getCupScale() {
        float f = (float)DCsConfig.setCupScale;
        if (f < 0.01f) {
            f = 0.01f;
        } else if (f > 10.0f) {
            f = 10.0f;
        }
        return f;
    }

    public static float getCupSize() {
        float f = (float)DCsConfig.setCupScale;
        if (f < 0.5f) {
            f = 0.5f;
        } else if (f > 2.0f) {
            f = 2.0f;
        }
        return 0.3f * f;
    }

    public static Item getModItem(String modId, String name) {
        Item ret = GameRegistry.findItem((String)modId, (String)name);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static Block getModBlock(String modId, String name) {
        Block ret = GameRegistry.findBlock((String)modId, (String)name);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public static BiomeGenBase checkCurrentBiome(World world, EntityPlayer player) {
        BiomeGenBase biome = BiomeGenBase.field_76772_c;
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        biome = world.func_72807_a(x, z);
        return biome;
    }

    public static boolean addPotionEffectDC(EntityLivingBase living, PotionEffect effect) {
        boolean flag = DCsAppleMilk.succeedAddPotion;
        if (flag) {
            living.func_70690_d(effect);
        } else {
            living.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 300, 0));
        }
        return flag;
    }

    public static boolean notEmptyItem(ItemStack item) {
        return item != null && item.field_77994_a != 0 && item.func_77973_b() != null;
    }

    public static boolean checkDebugModePass(String pass) {
        byte[] b = null;
        String get = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(pass.getBytes());
            b = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            AMTLogger.logger.warn("Failed to check password...", (Throwable)e);
        }
        get = Util.getStringFromBytes(b);
        AMTLogger.debugInfo("Get String : " + get);
        if (!get.isEmpty()) {
            boolean match = get.matches("7805f2fa0adc68cd9a8f7cb2135e0b57");
            AMTLogger.info("DebugMode : " + match);
            return match;
        }
        return true;
    }

    private static String getStringFromBytes(byte[] b) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            if ((b[i] & 0xFF) < 16) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(0xFF & b[i]));
        }
        return builder.toString();
    }
}

