/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class ResourceUtil {
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_ITEM_SHEET = new ResourceLocation("textures/atlas/items.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_ALTERNATE = new ResourceLocation("textures/font/ascii_sga.png");
    public static TextureMap blockIconRegister;
    public static TextureMap itemIconRegister;
    private static File mods;
    private static File assets;

    @SideOnly(value=Side.CLIENT)
    public static void initResourceUtil() {
        mods = new File(Minecraft.func_71410_x().field_71412_D, "mods");
        assets = new File(Minecraft.func_71410_x().field_71412_D, "assets");
    }

    public static ResourceLocation getResourceUtil(String modid, String resource) {
        return new ResourceLocation(modid, resource);
    }

    public static ResourceLocation getGuiResource(String modid, String gui) {
        return ResourceUtil.getResourceUtil(modid, "textures/gui/" + gui);
    }

    public static ResourceLocation getEntityTexture(String modid, String texture) {
        return ResourceUtil.getResourceUtil(modid, "textures/entities/" + texture);
    }

    public static ResourceLocation getIcon(String modid, String icon) {
        return ResourceUtil.getResourceUtil(modid, "textures/icons/" + icon);
    }

    public static ResourceLocation getModelTexture(String modid, String texture) {
        return ResourceUtil.getResourceUtil(modid, "textures/model/" + texture);
    }

    public static ResourceLocation getResource(String modid, String folder, String icon) {
        return ResourceUtil.getResourceUtil(modid, "textures/" + folder + "/" + icon);
    }

    public static IIcon getIconfromRegistry(String modid, String folder, String icon) {
        return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(ResourceUtil.getResource(modid, folder, icon))).func_110572_b("missingno");
    }

    public static File getModsFolder() {
        if (mods == null) {
            ResourceUtil.initResourceUtil();
        }
        return mods;
    }

    public static File getAssetsFolder() {
        if (assets == null) {
            ResourceUtil.initResourceUtil();
        }
        return assets;
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static final void setBlockTextureSheet() {
        ResourceUtil.bindTexture(MC_BLOCK_SHEET);
    }

    public static final void setItemTextureSheet() {
        ResourceUtil.bindTexture(MC_ITEM_SHEET);
    }
}

