/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtil {
    public static boolean isFluidWater(Fluid fluid) {
        return fluid.equals(FluidRegistry.WATER);
    }

    public static boolean isFluidWater(FluidStack fluid) {
        return FluidUtil.isFluidWater(fluid.getFluid());
    }

    public static boolean isFluidLava(Fluid fluid) {
        return fluid.equals(FluidRegistry.LAVA);
    }

    public static boolean isFluidLava(FluidStack fluid) {
        return FluidUtil.isFluidLava(fluid.getFluid());
    }

    public static boolean areFluidsEqual(FluidStack baseFluid, FluidStack secondFluid) {
        return baseFluid != null && secondFluid != null ? baseFluid.isFluidEqual(secondFluid) : false;
    }

    public static void combineFluidStacks(FluidStack baseFluid, FluidStack secondFluid) {
        if (baseFluid != null && secondFluid != null && FluidUtil.areFluidsEqual(baseFluid, secondFluid)) {
            baseFluid.amount += secondFluid.amount;
            secondFluid = null;
        }
    }

    public static Fluid getContainerFluid(ItemStack stack) {
        FluidStack temp;
        Fluid fluid = null;
        if (stack != null && FluidContainerRegistry.isFilledContainer((ItemStack)stack) && (temp = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null && temp.getFluid() != null) {
            fluid = temp.getFluid();
        }
        return fluid;
    }

    public static ArrayList<ItemStack> getContainersForFluid(Fluid targetFluid) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (targetFluid != null) {
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                Fluid fluid = data.fluid.getFluid();
                if (fluid == null || !fluid.equals(targetFluid) && fluid.getID() != targetFluid.getID()) continue;
                list.add(data.filledContainer);
            }
        }
        return list;
    }
}

