/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EnchantmentUtil {
    public static int getUniqueEnchantID() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] != null) continue;
            return i;
        }
        return 0;
    }

    public static ItemStack getEnchantedBook(Enchantment enchant, short lvl) {
        ItemStack book = new ItemStack((Item)Items.field_151134_bR);
        if (enchant != null && lvl > 0) {
            book.field_77990_d = new NBTTagCompound();
            NBTTagList enchantList = new NBTTagList();
            NBTTagCompound enchantTag = new NBTTagCompound();
            enchantTag.func_74777_a("id", (short)enchant.field_77352_x);
            enchantTag.func_74777_a("lvl", lvl);
            enchantList.func_74742_a((NBTBase)enchantTag);
            book.field_77990_d.func_74782_a("StoredEnchantments", (NBTBase)enchantList);
        }
        return book;
    }

    public static ItemStack addEnchantment(ItemStack stack, Enchantment enchant, short lvl) {
        if (stack == null || enchant == null) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList enchantList = stack.func_77986_q();
        NBTTagCompound enchantTag = new NBTTagCompound();
        if (EnchantmentUtil.itemHasEnchant(stack, enchant)) {
            if (lvl > 0) {
                for (int i = 0; i < enchantList.func_74745_c(); ++i) {
                    NBTTagCompound enc = enchantList.func_150305_b(i);
                    if (!enc.func_74764_b("id") || enc.func_74765_d("id") != (short)enchant.field_77352_x) continue;
                    enc.func_74777_a("lvl", lvl);
                    break;
                }
            } else {
                for (int i = 0; i < enchantList.func_74745_c(); ++i) {
                    NBTTagCompound enc = enchantList.func_150305_b(i);
                    if (!enc.func_74764_b("id") || enc.func_74765_d("id") != (short)enchant.field_77352_x) continue;
                    enchantList.func_74744_a(i);
                    break;
                }
            }
        } else if (lvl > 0) {
            enchantTag.func_74777_a("id", (short)enchant.field_77352_x);
            enchantTag.func_74777_a("lvl", lvl);
            enchantList.func_74742_a((NBTBase)enchantTag);
        }
        stack.field_77990_d.func_74782_a("ench", (NBTBase)enchantList);
        return stack;
    }

    public static boolean itemHasEnchant(ItemStack stack, Enchantment enchant) {
        NBTTagList enchantList;
        if (stack != null && (enchantList = stack.func_77986_q()) != null) {
            for (int i = 0; i < enchantList.func_74745_c(); ++i) {
                short id = enchantList.func_150305_b(i).func_74765_d("id");
                Enchantment ench = Enchantment.field_77331_b[id];
                if (ench == null || ench.field_77352_x != enchant.field_77352_x) continue;
                return true;
            }
        }
        return false;
    }
}

