/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import net.lomeli.lomlib.LomLib;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockUtil {
    public static ItemStack getBlockFromModWithMeta(String itemString, int meta, String BlockClass) {
        ItemStack item = null;
        try {
            String itemClass = BlockClass;
            Object obj = Class.forName(itemClass).getField(itemString).get(null);
            if (obj instanceof Block) {
                item = new ItemStack((Block)obj, 1, meta);
            } else if (obj instanceof ItemStack) {
                item = (ItemStack)obj;
            }
            if (LomLib.debug) {
                LomLib.logger.logBasic(obj.toString());
            }
        }
        catch (Exception ex) {
            FMLLog.warning((String)("Could not retrieve block identified by: " + itemString), (Object[])new Object[0]);
        }
        return item;
    }

    public static ItemStack getBlockFromMod(String itemString, String BlockClass) {
        ItemStack item = null;
        try {
            String itemClass = BlockClass;
            Object obj = Class.forName(itemClass).getField(itemString).get(null);
            if (obj instanceof Block) {
                item = new ItemStack((Block)obj);
            } else if (obj instanceof ItemStack) {
                item = (ItemStack)obj;
            }
            if (LomLib.debug) {
                LomLib.logger.logBasic(obj.toString());
            }
        }
        catch (Exception ex) {
            FMLLog.warning((String)("Could not retrieve block identified by: " + itemString), (Object[])new Object[0]);
        }
        return item;
    }

    public static boolean isBlockAdjacentToWater(World world, int x, int y, int z) {
        Block water = Blocks.field_150355_j;
        BlockLiquid flowing = Blocks.field_150358_i;
        return world.func_147439_a(x, y + 1, z).equals(water) || world.func_147439_a(x, y - 1, z).equals(water) || world.func_147439_a(x + 1, y, z).equals(water) || world.func_147439_a(x - 1, y, z).equals(water) || world.func_147439_a(x, y, z + 1).equals(water) || world.func_147439_a(x, y, z - 1).equals(water) || world.func_147439_a(x, y + 1, z).equals(flowing) || world.func_147439_a(x, y - 1, z).equals(flowing) || world.func_147439_a(x + 1, y, z).equals(flowing) || world.func_147439_a(x - 1, y, z).equals(flowing) || world.func_147439_a(x, y, z + 1).equals(flowing) || world.func_147439_a(x, y, z - 1).equals(flowing);
    }

    public static int isBlockAdjacentToWaterSource(World world, int x, int y, int z) {
        int j = 0;
        if (world.func_72805_g(x - 1, y, z) == 0 && BlockUtil.isWaterSource(world, x - 1, y, z)) {
            ++j;
        }
        if (world.func_72805_g(x + 1, y, z) == 0 && BlockUtil.isWaterSource(world, x + 1, y, z)) {
            ++j;
        }
        if (world.func_72805_g(x, y, z - 1) == 0 && BlockUtil.isWaterSource(world, x, y, z - 1)) {
            ++j;
        }
        if (world.func_72805_g(x, y, z + 1) == 0 && BlockUtil.isWaterSource(world, x, y, z + 1)) {
            ++j;
        }
        return j;
    }

    public static boolean isWaterSource(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).equals(Blocks.field_150355_j);
    }

    public static boolean isBlockWater(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).equals(Blocks.field_150355_j) || world.func_147439_a(x, y, z).equals(Blocks.field_150358_i);
    }

    public static boolean isAboveBlock(Entity entity, int x, int y, int z) {
        return entity.field_70165_t < (double)x + 1.4 && entity.field_70165_t >= (double)x && entity.field_70163_u < (double)y + 1.5 && entity.field_70163_u >= (double)y && entity.field_70161_v < (double)z + 1.4 && entity.field_70161_v >= (double)z;
    }

    public static boolean isThereANeighborChest(World world, int x, int y, int z) {
        BlockChest chest = Blocks.field_150486_ae;
        Block trap = Blocks.field_150447_bR;
        boolean yesThereIs = false;
        if (world.func_147439_a(x, y, z).equals(chest)) {
            if (world.func_147439_a(x + 1, y, z).equals(chest)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x - 1, y, z).equals(chest)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x, y, z + 1).equals(chest)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x, y, z - 1).equals(chest)) {
                yesThereIs = true;
            }
        } else if (world.func_147439_a(x, y, z).equals(trap)) {
            if (world.func_147439_a(x + 1, y, z).equals(trap)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x - 1, y, z).equals(trap)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x, y, z + 1).equals(trap)) {
                yesThereIs = true;
            }
            if (world.func_147439_a(x, y, z - 1).equals(trap)) {
                yesThereIs = true;
            }
        }
        return yesThereIs;
    }

    public static int determineOrientation(World world, int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - (double)entity.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return 1;
            }
            if ((double)y - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        GameRegistry.registerTileEntity(tile, (String)tile.getName().toLowerCase());
    }

    public static boolean isTransparent(Block block) {
        return block.func_149717_k() != 255;
    }
}

