/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.lib;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class Vector3 {
    private double x;
    private double y;
    private double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Vector3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public static Vector3 fromEntity(Entity e) {
        return new Vector3(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public static Vector3 fromEntityCenter(Entity e) {
        return new Vector3(e.field_70165_t, e.field_70163_u - e.func_70033_W() + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
    }

    public static Vector3 fromPlayer(EntityPlayer player, float partialTicks) {
        return new Vector3(player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks, player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks, player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks);
    }

    public static Vector3 fromTile(TileEntity tile) {
        return new Vector3(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public static Vector3 fromTileCenter(TileEntity tile) {
        return Vector3.fromTile(tile).add(0.5);
    }

    public static Vector3 fromAxes(double[] da) {
        return new Vector3(da[2], da[0], da[1]);
    }

    public Vector3 set(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public Vector3 set(double d, double d1, double d2) {
        this.x = d;
        this.y = d1;
        this.z = d2;
        return this;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3 add(double d, double d1, double d2) {
        return new Vector3(this.x + d, this.y + d1, this.z + d2);
    }

    public Vector3 add(Vector3 vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vector3 add(double d) {
        return this.add(d, d, d);
    }

    public Vector3 sub(double d, double d1, double d2) {
        return new Vector3(this.x - d, this.y - d1, this.z - d2);
    }

    public Vector3 sub(Vector3 vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vector3 sub(double d) {
        return this.sub(d, d, d);
    }

    public Vector3 mul(double d, double d1, double d2) {
        return new Vector3(this.x * d, this.y * d1, this.z * d2);
    }

    public Vector3 mul(Vector3 vec) {
        return this.mul(vec.x, vec.y, vec.z);
    }

    public Vector3 mul(double d) {
        return this.mul(d, d, d);
    }

    public Vector3 div(double d, double d1, double d2) {
        return new Vector3(this.x / d, this.y / d1, this.z / d2);
    }

    public Vector3 div(Vector3 vec) {
        return this.div(vec.x, vec.y, vec.z);
    }

    public Vector3 div(double d) {
        return this.div(d, d, d);
    }

    public Vector3 eulerAngles() {
        return new Vector3(Math.toDegrees(Math.atan2(this.x, this.z)), Math.toDegrees(-Math.atan2(this.y, Math.hypot(this.z, this.x))), 0.0);
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double distance(Vector3 v) {
        return this.clone().sub(v).magnitude();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector3) {
            Vector3 vec = (Vector3)obj;
            return this.x == vec.x && this.y == vec.y && this.z == vec.z;
        }
        return false;
    }

    public double angle(Vector3 vec) {
        return Math.acos(this.clone().normalize().dotProduct(vec.clone().normalize()));
    }

    public Vector3 normalize() {
        double d = this.magnitudeSquared();
        if (d != 0.0) {
            this.mul(1.0 / d);
        }
        return this;
    }

    public double dotProduct(Vector3 vec) {
        double d = vec.x * this.x + vec.y * this.y + vec.z * this.z;
        if (d > 1.0 && d < 1.00001) {
            d = 1.0;
        } else if (d < -1.0 && d > -1.00001) {
            d = -1.0;
        }
        return d;
    }

    public double dotProduct(double d, double d1, double d2) {
        return d * this.x + d1 * this.y + d2 * this.z;
    }

    public Vector3 crossProduct(Vector3 vec) {
        double d = this.y * vec.z - this.z * vec.y;
        double d1 = this.z * vec.x - this.x * vec.z;
        double d2 = this.x * vec.y - this.y * vec.x;
        this.x = d;
        this.y = d1;
        this.z = d2;
        return this;
    }

    public String toString() {
        return "Vector3[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public int hashCode() {
        long hx = Double.doubleToLongBits(this.x);
        long hy = Double.doubleToLongBits(this.y);
        long hz = Double.doubleToLongBits(this.z);
        Long hash = hx ^ hx >>> 32;
        hash = 31L * hash + hy ^ hy >>> 32;
        hash = 31L * hash + hz ^ hz >>> 32;
        return hash.intValue();
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }
}

