/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.core.recipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lomeli.lomlib.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessFluidRecipe
implements IRecipe {
    public ArrayList input = new ArrayList();
    private ItemStack output = null;

    public ShapelessFluidRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                if (FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)in))) {
                    this.input.add(FluidUtil.getContainersForFluid(FluidUtil.getContainerFluid((ItemStack)in)));
                    continue;
                }
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                if (FluidContainerRegistry.isFilledContainer((ItemStack)new ItemStack((Item)in))) {
                    this.input.add(FluidUtil.getContainersForFluid(FluidUtil.getContainerFluid(new ItemStack((Item)in))));
                    continue;
                }
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                if (((String)in).startsWith("fluid$")) {
                    String fluidName = ((String)in).substring(6);
                    if (!FluidRegistry.isFluidRegistered((String)fluidName)) continue;
                    this.input.add(FluidUtil.getContainersForFluid(FluidRegistry.getFluid((String)fluidName)));
                    continue;
                }
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public ShapelessFluidRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessFluidRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    ShapelessFluidRecipe(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        Iterator iterator = recipe.field_77579_b.iterator();
        while (iterator.hasNext()) {
            ItemStack ingred;
            Object finalObj = ingred = (ItemStack)iterator.next();
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)false)) {
                    finalObj = OreDictionary.getOres((String)replace.getValue());
                    break;
                }
                if (!FluidContainerRegistry.isFilledContainer((ItemStack)replace.getKey())) continue;
                finalObj = FluidUtil.getContainersForFluid(FluidContainerRegistry.getFluidForFilledItem((ItemStack)replace.getKey()).getFluid());
                break;
            }
            this.input.add(finalObj);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }
}

