/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.core.recipes;

import java.util.ArrayList;
import net.lomeli.lomlib.core.recipes.IAnvilRecipe;
import net.lomeli.lomlib.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class FluidAnvilRecipe
implements IAnvilRecipe {
    private ItemStack output = null;
    private Object[] inputs = new Object[2];
    private int expLvlCost = 0;

    public FluidAnvilRecipe(ItemStack output, Object leftInput, Object rightInput, int expCost) {
        this.output = output;
        this.addInput(leftInput, 0);
        this.addInput(rightInput, 1);
        this.setXPCost(expCost);
        if (leftInput == null && rightInput == null) {
            throw new RuntimeException("Invalid Anvil Recipe: Both inputs cannot be null!");
        }
    }

    public FluidAnvilRecipe(ItemStack output, Object input, int expCost) {
        this(output, input, null, expCost);
    }

    private void setXPCost(int exp) {
        if (exp < 0) {
            throw new RuntimeException("Invalid Anvil Recipe: Recipe cost less than zero!");
        }
        this.expLvlCost = exp;
    }

    private void addInput(Object input, int slot) {
        if ((slot == 0 || slot == 1) && input != null) {
            if (input instanceof ItemStack) {
                this.inputs[slot] = input;
            } else if (input instanceof Item) {
                this.inputs[slot] = new ItemStack((Item)input, 1);
            } else if (input instanceof Block) {
                this.inputs[slot] = new ItemStack((Block)input, 1);
            } else if (input instanceof String) {
                String in = (String)input;
                if (in.startsWith("fluid$")) {
                    String fluidName = in.substring(6);
                    if (FluidRegistry.isFluidRegistered((String)fluidName)) {
                        this.inputs[slot] = FluidUtil.getContainersForFluid(FluidRegistry.getFluid((String)fluidName));
                    }
                } else {
                    this.inputs[slot] = OreDictionary.getOres((String)in);
                }
            } else {
                throw new RuntimeException("Invalid Anvil Recipe: " + input);
            }
        }
    }

    @Override
    public boolean matches(ItemStack left, ItemStack right) {
        return this.doItemsMatch(left, 0) && this.doItemsMatch(right, 1);
    }

    @Override
    public boolean doItemsMatch(ItemStack itemStack, int slot) {
        if (slot == 0 || slot == 1) {
            Object target = this.inputs[slot];
            if (target == null) {
                return itemStack == null;
            }
            if (target instanceof ItemStack) {
                if (!this.checkItemEquals((ItemStack)target, itemStack)) {
                    return false;
                }
            } else if (target instanceof ArrayList) {
                boolean matched = false;
                for (ItemStack item : (ArrayList)target) {
                    matched = matched || this.checkItemEquals(item, itemStack);
                }
                if (!matched) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    @Override
    public ItemStack getCraftingResult(ItemStack left, ItemStack right) {
        return this.output.func_77946_l();
    }

    @Override
    public ItemStack recipeOutput() {
        return this.output;
    }

    @Override
    public Object[] recipeInputs() {
        return this.inputs;
    }

    @Override
    public int recipeCost() {
        return this.expLvlCost;
    }
}

