/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.lomeli.lomlib.core.recipes.AnvilRecipeManager;
import net.lomeli.lomlib.core.recipes.IAnvilRecipe;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class AnvilRecipeHandler
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return "textures/gui/container/anvil.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.lomlib:anvilRecipe");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRepair.class;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (IAnvilRecipe recipe : AnvilRecipeManager.getRegistry()) {
                Object[] inputs;
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.recipeOutput(), (ItemStack)result) || (inputs = recipe.recipeInputs()) == null || inputs.length <= 0) continue;
                this.arecipes.add(new CachedAnvilRecipe(inputs[0], inputs.length >= 2 ? inputs[1] : null, result, recipe.recipeCost()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            for (IAnvilRecipe recipe : AnvilRecipeManager.getRegistry()) {
                Object[] inputs;
                if (!recipe.doItemsMatch(ingredient, 0) && !recipe.doItemsMatch(ingredient, 1) || (inputs = recipe.recipeInputs()) == null || inputs.length <= 0) continue;
                this.arecipes.add(new CachedAnvilRecipe(inputs[0], inputs.length >= 2 ? inputs[1] : null, recipe.recipeOutput(), recipe.recipeCost()));
            }
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)10, (int)25, (int)15, (int)41, (int)143, (int)30);
    }

    public void drawExtras(int recipe) {
        CachedAnvilRecipe cRecipe = (CachedAnvilRecipe)((Object)this.arecipes.get(recipe));
        if (cRecipe.expCost > 0) {
            int x = 70;
            int y = 14;
            int k = 8453920;
            if (cRecipe.expCost >= 40) {
                k = 0xFF6060;
            }
            int l = 0xFF000000 | (k & 0xFCFCFC) >> 2 | k & 0xFF000000;
            String s = String.format(StatCollector.func_74838_a((String)"container.repair.cost"), cRecipe.expCost);
            GuiDraw.drawStringC((String)s, (int)x, (int)(y + 1), (int)l, (boolean)false);
            GuiDraw.drawStringC((String)s, (int)(x + 1), (int)y, (int)l, (boolean)false);
            GuiDraw.drawStringC((String)s, (int)(x + 1), (int)(y + 1), (int)l, (boolean)false);
            GuiDraw.drawStringC((String)s, (int)x, (int)y, (int)k, (boolean)false);
        }
    }

    public class CachedAnvilRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> inputs;
        public PositionedStack output;
        public int expCost;

        public CachedAnvilRecipe(ItemStack output, int expCost) {
            super((TemplateRecipeHandler)AnvilRecipeHandler.this);
            this.expCost = expCost;
            this.inputs = new ArrayList<PositionedStack>();
            for (IAnvilRecipe recipe : AnvilRecipeManager.getRegistry()) {
                Object[] inputs;
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.recipeOutput(), (ItemStack)output)) continue;
                if (this.output == null) {
                    this.output = new PositionedStack((Object)output, 129, 31);
                }
                if ((inputs = recipe.recipeInputs()) == null || inputs.length <= 0) break;
                this.inputs.add(new PositionedStack(inputs[0], 22, 31));
                if (inputs.length < 2) break;
                this.inputs.add(new PositionedStack(inputs[1], 71, 31));
                break;
            }
        }

        public CachedAnvilRecipe(Object input1, Object input2, ItemStack output, int expCost) {
            super((TemplateRecipeHandler)AnvilRecipeHandler.this);
            this.output = new PositionedStack((Object)output, 129, 31);
            this.inputs = new ArrayList<PositionedStack>();
            this.inputs.add(new PositionedStack(input1, 22, 31));
            if (input2 != null) {
                this.inputs.add(new PositionedStack(input2, 71, 31));
            }
            this.expCost = expCost;
        }

        public List<PositionedStack> getIngredients() {
            return this.inputs;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

