/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DemonicIngotHandler {
    DataParameter<Object> ITEM = (DataParameter)ObfuscationReflectionHelper.getPrivateValue(EntityItem.class, null, (String[])new String[]{"field_184525_c", "ITEM", "field_184533_c", "field_184545_d", "field_176599_b"});
    ImmutableSet<Block> netherBlocks = ImmutableSet.of((Object)Blocks.field_150385_bj, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150386_bk);
    WeakLinkedSet<EntityItem> goldIngotsServer = new WeakLinkedSet();
    WeakLinkedSet<EntityItem> goldIngotsClient = new WeakLinkedSet();

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent event) {
        ItemStack entityItem;
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem && (StackHelper.isNull(entityItem = this.getRawStack((EntityItem)entity)) || entityItem.func_77973_b() == Items.field_151043_k)) {
            WeakLinkedSet<EntityItem> entityItems = event.getWorld().field_72995_K ? this.goldIngotsClient : this.goldIngotsServer;
            entityItems.add((EntityItem)entity);
        }
    }

    public ItemStack getRawStack(EntityItem entityItem) {
        Object itemStackOptional = entityItem.func_184212_Q().func_187225_a(this.ITEM);
        if (itemStackOptional instanceof ItemStack) {
            return (ItemStack)itemStackOptional;
        }
        if (itemStackOptional instanceof Optional) {
            return (ItemStack)((Optional)itemStackOptional).or(Optional.fromNullable((Object)StackHelper.empty())).orNull();
        }
        return StackHelper.empty();
    }

    @SubscribeEvent
    public void run(TickEvent.ClientTickEvent event) {
        this.handleIngots(this.goldIngotsClient);
    }

    @SubscribeEvent
    public void run(TickEvent.ServerTickEvent event) {
        this.handleIngots(this.goldIngotsServer);
    }

    private void handleIngots(WeakLinkedSet<EntityItem> goldIngots) {
        Iterator<EntityItem> iterator = goldIngots.iterator();
        while (iterator.hasNext()) {
            EntityItem goldIngotItem = iterator.next();
            if (goldIngotItem.field_70128_L) {
                iterator.remove();
                continue;
            }
            ItemStack rawStack = this.getRawStack(goldIngotItem);
            if (StackHelper.isNull(rawStack)) continue;
            if (rawStack.func_77973_b() != Items.field_151043_k) {
                iterator.remove();
                continue;
            }
            World world = goldIngotItem.field_70170_p;
            AxisAlignedBB bb = goldIngotItem.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1);
            int x1 = MathHelper.func_76128_c((double)bb.field_72340_a);
            int x2 = MathHelper.func_76143_f((double)bb.field_72336_d);
            int y1 = MathHelper.func_76128_c((double)bb.field_72338_b);
            int y2 = MathHelper.func_76143_f((double)bb.field_72337_e);
            int z1 = MathHelper.func_76128_c((double)bb.field_72339_c);
            int z2 = MathHelper.func_76143_f((double)bb.field_72334_f);
            BlockPos.PooledMutableBlockPos mutPos = BlockPos.PooledMutableBlockPos.func_185346_s();
            boolean found = false;
            block1: for (int x = x1; x < x2; ++x) {
                for (int y = y1; y < y2; ++y) {
                    for (int z = z1; z < z2; ++z) {
                        if (world.func_180495_p((BlockPos)mutPos.func_181079_c(x, y, z)).func_185904_a() != Material.field_151587_i) continue;
                        found = true;
                        for (EnumFacing dir : EnumFacing.field_176754_o) {
                            if (this.netherBlocks.contains((Object)world.func_180495_p(mutPos.func_177972_a(dir)).func_177230_c())) continue;
                            found = false;
                            break;
                        }
                        if (found) break block1;
                    }
                }
            }
            if (!found || world.field_72995_K || !(world instanceof WorldServer)) continue;
            WorldServer worldServer = (WorldServer)world;
            worldServer.func_180505_a(EnumParticleTypes.LAVA, false, goldIngotItem.field_70165_t, goldIngotItem.field_70163_u, goldIngotItem.field_70161_v, 100, 0.0, 0.0, 0.0, 0.0, new int[0]);
            goldIngotItem.func_70106_y();
            EntityItem demonicIngotItem = new EntityItem(world, goldIngotItem.field_70165_t, goldIngotItem.field_70163_u, goldIngotItem.field_70161_v, ItemIngredients.Type.DEMON_INGOT.newStack(StackHelper.getStacksize(rawStack)));
            world.func_72838_d((Entity)demonicIngotItem);
            iterator.remove();
        }
    }
}

