/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.textures.TextureLocation;
import com.rwtema.extrautils2.textures.TextureRandom;
import com.rwtema.extrautils2.tile.TileResonator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorativeSolid
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public BlockDecorativeSolid() {
        super(Material.field_151576_e);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = decorState.createTexture(this);
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeSolid.decor))).tex;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0.0f;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeSolid.decor))).enchantBonus;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ((DecorStates)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)decor))).addInformation(stack, playerIn, tooltip, advanced);
    }

    public static enum DecorStates implements IItemStackMaker
    {
        borderstone{

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(4), "stone", "bricksStone", "stone", "bricksStone");
            }
        }
        ,
        stonecross{

            @Override
            public void addRecipes() {
            }
        }
        ,
        stoneslab{

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(4), "SS", "SS", Character.valueOf('S'), Blocks.field_150417_aV);
            }
        }
        ,
        stoneburnt{

            @Override
            public void addRecipes() {
                if (XU2Entries.resonator.enabled) {
                    TileResonator.register(stoneslab.newStack(1), this.newStack(1), 800);
                } else {
                    CraftingHelper.addShaped(this.newStack(8), "SSS", "ScS", "SSS", Character.valueOf('S'), stoneslab.newStack(1), Character.valueOf('c'), Items.field_151044_h);
                }
            }
        }
        ,
        sandy_glass{

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(4), "sand", "blockGlassColorless", "sand", "blockGlassColorless");
            }
        }
        ,
        truchet{

            @Override
            public void addRecipes() {
            }

            @Override
            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public ISolidWorldTexture createTexture(XUBlockConnectedTextureBase block) {
                return new TextureRandom("truchet"){

                    @Override
                    protected void assignBaseTextures() {
                        for (int i = 0; i < 6; ++i) {
                            int j = i == 0 || i == 2 || i == 3 ? 2 : 0;
                            this.baseTexture[i] = this.textures[0];
                        }
                    }
                };
            }
        }
        ,
        blue_quartz{

            @Override
            public void addRecipes() {
            }

            @Override
            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public ISolidWorldTexture createTexture(XUBlockConnectedTextureBase block) {
                return new TextureLocation("blue_quartz_thue_morse"){

                    @Override
                    protected void assignBaseTextures() {
                        for (int i = 0; i < 6; ++i) {
                            int j = i == 0 || i == 2 || i == 3 ? 2 : 0;
                            this.baseTexture[i] = this.textures[j % this.textures.length];
                        }
                    }

                    @Override
                    protected int getRandomIndex(IBlockAccess world, BlockPos pos, EnumFacing side) {
                        int i = this.bitSumXor(pos.func_177958_n()) ^ this.bitSumXor(pos.func_177956_o()) ^ this.bitSumXor(pos.func_177952_p());
                        this.assignBaseTextures();
                        if (side == EnumFacing.DOWN || side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                            i ^= 2;
                        }
                        return i & 0xFF;
                    }

                    public int bitSumXor(int x) {
                        int t = 0;
                        while (x != 0) {
                            t ^= x;
                            x >>>= 1;
                        }
                        return t;
                    }
                };
            }
        };

        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        public float enchantBonus = 0.0f;

        public abstract void addRecipes();

        public ItemStack newStack(int amount) {
            return XU2Entries.decorativeSolid.newStack(amount, new Object[]{decor, this});
        }

        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture createTexture(XUBlockConnectedTextureBase block) {
            return new ConnectedTexture(this.toString(), block.xuBlockState.defaultState.func_177226_a((IProperty)decor, (Comparable)((Object)this)), block);
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }
    }
}

