/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.gui.IGuiProvider;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageOpenGui
extends MessageToClient<MessageOpenGui> {
    private ResourceLocation guiID;
    private BlockPos pos;
    private NBTTagCompound data;
    private int windowID;

    public MessageOpenGui() {
    }

    public MessageOpenGui(ResourceLocation key, BlockPos p, @Nullable NBTTagCompound tag, int wid) {
        this.guiID = key;
        this.pos = p;
        this.data = tag;
        this.windowID = wid;
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.guiID = LMNetUtils.readResourceLocation(io);
        this.pos = LMNetUtils.readPos(io);
        this.data = ByteBufUtils.readTag((ByteBuf)io);
        this.windowID = io.readUnsignedByte();
    }

    public void toBytes(ByteBuf io) {
        LMNetUtils.writeResourceLocation(io, this.guiID);
        LMNetUtils.writePos(io, (Vec3i)this.pos);
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.data);
        io.writeByte(this.windowID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageOpenGui m, EntityPlayer player) {
        GuiScreen g;
        IGuiProvider guiProvider = FTBLibModClient.getGui(m.guiID);
        if (guiProvider != null && (g = guiProvider.getGui(player, m.pos, m.data)) != null) {
            Minecraft.func_71410_x().func_147108_a(g);
            player.field_71070_bA.field_75152_c = m.windowID;
        }
    }
}

