/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.item;

import com.feed_the_beast.ftbl.api.item.IMaterial;
import com.feed_the_beast.ftbl.api.item.IMetaLookup;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ItemMaterialsLM
extends Item
implements IMetaLookup<IMaterial> {
    private final TIntObjectHashMap<IMaterial> materials = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> unlocalizedNameMap;
    private IMaterial defValue = Air.INSTANCE;
    private String folder = "";

    public ItemMaterialsLM() {
        this.unlocalizedNameMap = new TIntObjectHashMap();
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void setFolder(String s) {
        this.folder = s;
    }

    public void setDefaultMaterial(IMaterial m) {
        this.defValue = m;
    }

    public void add(IMaterial m) {
        if (m.isAdded()) {
            m.setItem(this);
        }
        this.materials.put(m.getMetadata(), (Object)m);
    }

    public final void addAll(Class<?> c) {
        try {
            this.addAll(LMUtils.getObjects(IMaterial.class, c, null, false).values());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void addAll(Iterable<IMaterial> c) {
        c.forEach(this::add);
    }

    @Override
    public Collection<IMaterial> getValues() {
        return this.materials.valueCollection();
    }

    @Override
    public IMaterial get(int metadata) {
        IMaterial m = (IMaterial)this.materials.get(metadata);
        return m == null ? this.defValue : m;
    }

    public String func_77667_c(ItemStack is) {
        int meta = is.func_77960_j();
        String s = (String)this.unlocalizedNameMap.get(meta);
        if (s == null) {
            IMaterial m = this.get(meta);
            s = m.isAdded() ? this.getRegistryName().func_110624_b() + ".item." + (this.folder.isEmpty() ? m.func_176610_l() : this.folder + '.' + m.func_176610_l()) : m.getStack(1).func_77977_a();
            this.unlocalizedNameMap.put(meta, (Object)s);
        }
        return s;
    }

    public void loadModels() {
        for (IMaterial i : this.getValues()) {
            ResourceLocation rl = new ResourceLocation(this.getRegistryName().func_110624_b(), this.folder.isEmpty() ? i.func_176610_l() : this.folder + '/' + i.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(rl, "inventory"));
        }
    }

    public void func_150895_a(Item item, CreativeTabs c, List<ItemStack> l) {
        for (IMaterial m : this.getValues()) {
            if (!m.isAdded()) continue;
            l.add(new ItemStack(m.getItem(), 1, m.getMetadata()));
        }
    }

    public static enum Air implements IMaterial
    {
        INSTANCE;


        @Override
        public Item getItem() {
            return Item.func_150898_a((Block)Blocks.field_150350_a);
        }

        @Override
        public int getMetadata() {
            return 0;
        }

        public String func_176610_l() {
            return "air";
        }

        @Override
        public boolean isAdded() {
            return false;
        }
    }
}

