/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;

public class PropertyColor
extends PropertyBase {
    public static final String ID = "color";
    private int value;

    public PropertyColor() {
    }

    public PropertyColor(int v) {
        this.value = v;
    }

    public String func_176610_l() {
        return ID;
    }

    public int getColorValue() {
        return this.value;
    }

    public void setColorValue(int v) {
        this.value = v;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getColorValue();
    }

    @Override
    public String getString() {
        return LMColorUtils.getHex(this.getColorValue());
    }

    @Override
    public boolean getBoolean() {
        return this.getColorValue() != 0;
    }

    @Override
    public int getInt() {
        return this.getColorValue();
    }

    @Override
    public IConfigValue copy() {
        return new PropertyColor(this.getColorValue());
    }

    @Override
    public int getColor() {
        return 0xFF000000 | this.getColorValue();
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        block10: {
            try {
                if (text.indexOf(44) != -1) {
                    if (text.length() < 5) {
                        return false;
                    }
                    String[] s = text.split(",");
                    if (s.length == 3 || s.length == 4) {
                        int[] c = new int[4];
                        c[3] = 255;
                        for (int i = 0; i < s.length; ++i) {
                            c[i] = Integer.parseInt(s[i]);
                        }
                        if (!simulate) {
                            this.setColorValue(LMColorUtils.getRGBA(c[0], c[1], c[2], c[3]));
                        }
                        return true;
                    }
                    break block10;
                }
                if (text.length() < 6) {
                    return false;
                }
                if (text.startsWith("#")) {
                    text = text.substring(1);
                }
                int hex = Integer.parseInt(text, 16);
                if (!simulate) {
                    this.setColorValue(hex);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void func_152753_a(JsonElement json) {
        this.setColorValue(json.getAsInt());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getInt());
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeInt(this.getInt());
    }

    @Override
    public void readData(ByteBuf data) {
        this.setColorValue(data.readInt());
    }
}

