/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.NotificationId;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class Notification
implements INotification {
    private NotificationId id;
    private int color;
    private int timer;
    private List<ITextComponent> text;
    private ItemStack item;

    public Notification(NotificationId i) {
        this.id = i;
        this.text = new ArrayList<ITextComponent>();
        this.setDefaults();
    }

    public Notification setError(ITextComponent title) {
        ITextComponent t = title.func_150259_f();
        t.func_150256_b().func_150238_a(TextFormatting.WHITE);
        this.addText(t);
        this.timer = 3000;
        this.color = -3389111;
        this.item = new ItemStack(Blocks.field_180401_cv);
        return this;
    }

    public void setDefaults() {
        this.text.clear();
        this.timer = 3000;
        this.color = -10461088;
        this.item = null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof INotification && ((INotification)o).getId().equals(this.getId());
    }

    public String toString() {
        return this.getId() + ", text:" + this.getText() + ", col:" + LMColorUtils.getHex(this.color) + ", timer:" + this.getTimer() + ", item:" + this.getItem();
    }

    public Notification addText(ITextComponent t) {
        this.text.add(t);
        return this;
    }

    @Override
    public NotificationId getId() {
        return this.id;
    }

    @Override
    public List<ITextComponent> getText() {
        return this.text;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public Notification setItem(@Nullable ItemStack is) {
        this.item = is;
        return this;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    public Notification setTimer(int t) {
        this.timer = t;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public Notification setColor(int c) {
        this.color = c;
        return this;
    }

    public static Notification copy(INotification n) {
        Notification n1 = new Notification(n.getId());
        n1.getText().addAll(n.getText());
        n1.setColor(n.getColor());
        n1.setTimer(n.getTimer());
        n1.setItem(n.getItem());
        return n1;
    }
}

