/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.world;

import com.valkyrieofnight.environmentaltech.core.ETConfig;
import com.valkyrieofnight.environmentaltech.init.ETBlocks;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    private WorldGenMinable hardened_stone = new WorldGenMinable(ETBlocks.hardened_stone.func_176223_P(), ETConfig.hardenedStoneNodeSize);
    private WorldGenMinable bassalt = new WorldGenMinable(ETBlocks.basalt.func_176223_P(), ETConfig.basaltNodeSize);
    private WorldGenMinable alabaster = new WorldGenMinable(ETBlocks.alabaster.func_176223_P(), ETConfig.alabasterNodeSize);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_186058_p()) {
            case NETHER: {
                break;
            }
            case THE_END: {
                break;
            }
            default: {
                if (ETConfig.enableHardenedStoneGeneration) {
                    this.runGen((WorldGenerator)this.hardened_stone, world, random, chunkX, chunkZ, ETConfig.hardenedStoneNodes, ETConfig.hardenedStoneMinHeight, ETConfig.hardenedStoneMaxHeight);
                }
                if (ETConfig.enableAlabasterGeneration) {
                    this.runGen((WorldGenerator)this.alabaster, world, random, chunkX, chunkZ, ETConfig.alabasterNodes, ETConfig.alabasterMinHeight, ETConfig.alabasterMaxHeight);
                }
                if (!ETConfig.enableBasaltGeneration) break;
                this.runGen((WorldGenerator)this.bassalt, world, random, chunkX, chunkZ, ETConfig.basaltNodes, ETConfig.basaltMinHeight, ETConfig.basaltMaxHeight);
            }
        }
    }

    public void runGen(WorldGenerator gen, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 255 || minHeight > maxHeight) {
            return;
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

