/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.multiblock.structure.components;

import com.valkyrieofnight.environmentaltech.api.block.EnumStructureBlock;
import com.valkyrieofnight.environmentaltech.api.block.IEnumStructureBlock;
import com.valkyrieofnight.environmentaltech.api.block.IStructureBlock;
import com.valkyrieofnight.environmentaltech.api.block.IStructureBlockSingle;
import com.valkyrieofnight.environmentaltech.block.multiblock.structure.BlockStructure;
import com.valkyrieofnight.environmentaltech.block.multiblock.structure.BlockStructureSingle;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileSlave;
import com.valkyrieofnight.valkyrielib.multiblock.block.VLBlockSlave;
import com.valkyrieofnight.valkyrielib.multiblock.structure.MultiblockComponent;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ComponentStructure
extends MultiblockComponent {
    private int tier;
    private VLBlockSlave defBlock;
    private IStructureBlock sb;

    public ComponentStructure(EnumStructureBlock tier, BlockStructure d) {
        this.tier = tier.getTier();
        this.defBlock = d;
        this.sb = d;
    }

    public ComponentStructure(int tier, BlockStructureSingle d) {
        this.tier = tier;
        this.defBlock = d;
        this.sb = d;
    }

    public boolean isCorrectComponent(World world, BlockPos pos) {
        IStructureBlock isb;
        TileEntity te = world.func_175625_s(pos);
        IBlockState bs = world.func_180495_p(pos);
        if (te == null) {
            return false;
        }
        if (te instanceof VLTileSlave) {
            if (((VLTileSlave)te).hasController()) {
                return false;
            }
        } else {
            return false;
        }
        return bs.func_177230_c() instanceof IStructureBlock && (isb = (IStructureBlock)bs.func_177230_c()).getTierFromState(bs) >= this.tier;
    }

    public IBlockState getBlockState() {
        if (this.defBlock instanceof BlockStructure) {
            return this.defBlock.func_176203_a(EnumStructureBlock.getFromTier(this.tier).getMetadata());
        }
        return this.defBlock.func_176223_P();
    }

    public boolean isType(Class k) {
        return k == IEnumStructureBlock.class;
    }

    public boolean isCorrectItemStack(ItemStack stack) {
        Block blk = Block.func_149634_a((Item)stack.func_77973_b());
        if (blk == null) {
            return false;
        }
        if (blk instanceof IEnumStructureBlock && ((IEnumStructureBlock)blk).getStructureTier(stack.func_77960_j()).getTier() >= this.tier) {
            return true;
        }
        return blk instanceof IStructureBlockSingle && ((IStructureBlockSingle)blk).getTier() >= this.tier;
    }

    public String getRequired() {
        String color = this.sb.getChatColor(this.tier);
        return color + LanguageHelper.toLoc((String)"gui.environmentaltech.structureblock") + " " + this.tier + " " + I18n.func_74838_a((String)"gui.environmentaltech.orabove");
    }
}

