/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FruitTreeWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        int xCh = chunkX * 16 + random.nextInt(16);
        int yCh = random.nextInt(128) + 64;
        int zCh = chunkZ * 16 + random.nextInt(16);
        Biome biome = world.func_180494_b(new BlockPos(xChunk + 16, 0, zChunk + 16));
        BlockPos blockPos = new BlockPos(xCh, yCh, zCh);
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return;
        }
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) && !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            switch (random.nextInt(9)) {
                case 0: {
                    if (HarvestCraft.config.appletreeGeneration) {
                        this.generateFruitTree(world, blockPos, "apple");
                        break;
                    }
                }
                case 1: {
                    if (HarvestCraft.config.avocadotreeGeneration) {
                        this.generateFruitTree(world, blockPos, "avocado");
                        break;
                    }
                }
                case 2: {
                    if (HarvestCraft.config.cherrytreeGeneration) {
                        this.generateFruitTree(world, blockPos, "cherry");
                        break;
                    }
                }
                case 3: {
                    if (HarvestCraft.config.chestnuttreeGeneration) {
                        this.generateFruitTree(world, blockPos, "chestnut");
                        break;
                    }
                }
                case 4: {
                    if (HarvestCraft.config.nutmegtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "nutmeg");
                        break;
                    }
                }
                case 5: {
                    if (HarvestCraft.config.peartreeGeneration) {
                        this.generateFruitTree(world, blockPos, "pear");
                        break;
                    }
                }
                case 6: {
                    if (HarvestCraft.config.plumtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "plum");
                        break;
                    }
                }
                case 7: {
                    if (HarvestCraft.config.walnuttreeGeneration) {
                        this.generateFruitTree(world, blockPos, "walnut");
                        break;
                    }
                }
                case 8: {
                    if (!HarvestCraft.config.gooseberrytreeGeneration) break;
                    this.generateFruitTree(world, blockPos, "gooseberry");
                }
            }
        }
        if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET))) {
            switch (random.nextInt(25)) {
                case 0: {
                    if (HarvestCraft.config.bananatreeGeneration) {
                        this.generateFruitTree(world, blockPos, "banana");
                        break;
                    }
                }
                case 1: {
                    if (HarvestCraft.config.cinnamontreeGeneration) {
                        this.generateFruitTree(world, blockPos, "cinnamon");
                        break;
                    }
                }
                case 2: {
                    if (HarvestCraft.config.coconuttreeGeneration) {
                        this.generateFruitTree(world, blockPos, "coconut");
                        break;
                    }
                }
                case 3: {
                    if (HarvestCraft.config.datetreeGeneration) {
                        this.generateFruitTree(world, blockPos, "date");
                        break;
                    }
                }
                case 4: {
                    if (HarvestCraft.config.dragonfruittreeGeneration) {
                        this.generateFruitTree(world, blockPos, "dragonfruit");
                        break;
                    }
                }
                case 5: {
                    if (HarvestCraft.config.papayatreeGeneration) {
                        this.generateFruitTree(world, blockPos, "papaya");
                        break;
                    }
                }
                case 6: {
                    if (HarvestCraft.config.almondtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "almond");
                        break;
                    }
                }
                case 7: {
                    if (HarvestCraft.config.apricottreeGeneration) {
                        this.generateFruitTree(world, blockPos, "apricot");
                        break;
                    }
                }
                case 8: {
                    if (HarvestCraft.config.cashewtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "cashew");
                        break;
                    }
                }
                case 9: {
                    if (HarvestCraft.config.duriantreeGeneration) {
                        this.generateFruitTree(world, blockPos, "durian");
                        break;
                    }
                }
                case 10: {
                    if (HarvestCraft.config.figtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "fig");
                        break;
                    }
                }
                case 11: {
                    if (HarvestCraft.config.grapefruittreeGeneration) {
                        this.generateFruitTree(world, blockPos, "grapefruit");
                        break;
                    }
                }
                case 12: {
                    if (HarvestCraft.config.lemontreeGeneration) {
                        this.generateFruitTree(world, blockPos, "lemon");
                        break;
                    }
                }
                case 13: {
                    if (HarvestCraft.config.limetreeGeneration) {
                        this.generateFruitTree(world, blockPos, "lime");
                        break;
                    }
                }
                case 14: {
                    if (HarvestCraft.config.mangotreeGeneration) {
                        this.generateFruitTree(world, blockPos, "mango");
                        break;
                    }
                }
                case 15: {
                    if (HarvestCraft.config.orangetreeGeneration) {
                        this.generateFruitTree(world, blockPos, "orange");
                        break;
                    }
                }
                case 16: {
                    if (HarvestCraft.config.paperbarktreeGeneration) {
                        this.generateFruitTree(world, blockPos, "paperbark");
                        break;
                    }
                }
                case 17: {
                    if (HarvestCraft.config.peachtreeGeneration) {
                        this.generateFruitTree(world, blockPos, "peach");
                        break;
                    }
                }
                case 18: {
                    if (HarvestCraft.config.pecantreeGeneration) {
                        this.generateFruitTree(world, blockPos, "pecan");
                        break;
                    }
                }
                case 19: {
                    if (HarvestCraft.config.peppercorntreeGeneration) {
                        this.generateFruitTree(world, blockPos, "peppercorn");
                        break;
                    }
                }
                case 20: {
                    if (HarvestCraft.config.persimmontreeGeneration) {
                        this.generateFruitTree(world, blockPos, "persimmon");
                        break;
                    }
                }
                case 21: {
                    if (HarvestCraft.config.pistachiotreeGeneration) {
                        this.generateFruitTree(world, blockPos, "pistachio");
                        break;
                    }
                }
                case 22: {
                    if (HarvestCraft.config.pomegranatetreeGeneration) {
                        this.generateFruitTree(world, blockPos, "pomegranate");
                        break;
                    }
                }
                case 23: {
                    if (HarvestCraft.config.starfruittreeGeneration) {
                        this.generateFruitTree(world, blockPos, "starfruit");
                        break;
                    }
                }
                case 24: {
                    if (HarvestCraft.config.vanillabeantreeGeneration) {
                        this.generateFruitTree(world, blockPos, "vanillabean");
                        break;
                    }
                }
                case 25: {
                    if (!HarvestCraft.config.olivetreeGeneration) break;
                    this.generateFruitTree(world, blockPos, "olive");
                }
            }
        }
        if ((BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) && HarvestCraft.config.mapletreeGeneration) {
            this.generateFruitTree(world, blockPos, "maple");
        }
    }

    private void generateFruitTree(World world, BlockPos pos, String fruitName) {
        BlockPamSapling sapling = FruitRegistry.getSapling(fruitName);
        if (sapling == null) {
            return;
        }
        sapling.worldGenTrees(world, pos);
    }
}

