/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.util.function.Consumer;
import net.shadowfacts.shadowlib.util.EnumUtils;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.button.UIButtonBase;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;
import net.shadowfacts.shadowmc.util.RedstoneMode;

public class UIButtonRedstoneMode
extends UIButtonBase {
    protected RedstoneMode mode;
    protected Consumer<RedstoneMode> callback;

    public UIButtonRedstoneMode(RedstoneMode mode, Consumer<RedstoneMode> callback, String id, String ... classes) {
        super("button-redstone-mode", id, classes);
        this.mode = mode;
        this.callback = callback;
    }

    public UIButtonRedstoneMode(Consumer<RedstoneMode> callback, String id, String ... classes) {
        this(RedstoneMode.ALWAYS, callback, id, classes);
    }

    @Override
    protected boolean handlePress(int mouseX, int mouseY, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.mode = EnumUtils.getNextValue(this.mode);
            this.callback.accept(this.mode);
        } else if (button == MouseButton.RIGHT) {
            this.mode = EnumUtils.getPreviousValue(this.mode);
            this.callback.accept(this.mode);
        }
        return true;
    }

    @Override
    protected void drawButton(int mouseX, int mouseY) {
        int u;
        UIHelper.bindTexture(TEXTURE);
        switch (this.mode) {
            default: {
                u = 80;
                break;
            }
            case NEVER: {
                u = 100;
                break;
            }
            case HIGH: {
                u = 60;
                break;
            }
            case LOW: {
                u = 40;
                break;
            }
            case PULSE: {
                u = 120;
            }
        }
        UIHelper.drawTexturedRect(this.x, this.y, u, 0, this.dimensions.width, this.dimensions.height);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(20, 20);
    }

    public RedstoneMode getMode() {
        return this.mode;
    }

    public void setMode(RedstoneMode mode) {
        this.mode = mode;
    }
}

