/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.gui.component.button;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.util.text.TextFormatting;
import net.shadowfacts.shadowlib.util.DesktopUtils;
import net.shadowfacts.shadowmc.ShadowMC;
import net.shadowfacts.shadowmc.gui.component.button.GUIButtonText;
import net.shadowfacts.shadowmc.util.Color;
import net.shadowfacts.shadowmc.util.MouseButton;

public class GUIButtonLink
extends GUIButtonText {
    protected URI link;

    public GUIButtonLink(int x, int y, int width, int height, String text, URI link) {
        super(x, y, width, height, null, text);
        this.link = link;
        this.callback = this::openLink;
        this.color = Color.BLUE;
    }

    public GUIButtonLink(int x, int y, int width, int height, String text, String link) {
        this(x, y, width, height, text, (URI)null);
        try {
            this.link = new URI(link);
        }
        catch (URISyntaxException e) {
            ShadowMC.log.error("Couldn't create URI for GUIButtonLink, disabling button");
            e.printStackTrace();
            this.enabled = false;
        }
    }

    public boolean openLink(GUIButtonText button, MouseButton mouseButton) {
        DesktopUtils.openWebpage(this.link);
        return true;
    }

    @Override
    protected void drawButton() {
        this.drawCenteredText(TextFormatting.UNDERLINE + this.text + TextFormatting.RESET, this.x, this.x + this.width, this.y, this.y + this.height, this.color);
    }
}

